/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.remoteTesting;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.net.util.Base64;

public class BrowserStackLinkGenerator {
    private EnvironmentVariables environmentVariables;
    private String username = null;
    private String accessKey = null;

    public BrowserStackLinkGenerator() {
    }

    public BrowserStackLinkGenerator(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.getBrowserStackCredentials();
    }

    public String linkFor(TestOutcome testOutcome) {
        if (this.username != null && this.accessKey != null) {
            return this.getVideoLink(testOutcome.getSessionId());
        }
        return null;
    }

    private String getVideoLink(String sessionID) {
        JsonObject browserstackSession = this.sessionInformation(sessionID);
        if (browserstackSession == null) {
            return null;
        }
        return browserstackSession.get("public_url").getAsString();
    }

    private JsonObject sessionInformation(String sessionID) {
        try {
            URL url = null;
            String respnse = "";
            StringBuffer sb = new StringBuffer();
            BufferedReader br = null;
            url = new URL("https://api.browserstack.com/automate/sessions/" + sessionID + ".json");
            HttpURLConnection con = (HttpURLConnection)url.openConnection();
            con.setRequestProperty("Content-Type", "application/json");
            con.setRequestProperty("Authorization", "Basic " + this.getBasicAuthenticationEncoding());
            con.setRequestMethod("GET");
            if (200 == con.getResponseCode()) {
                br = new BufferedReader(new InputStreamReader(con.getInputStream()));
                JsonParser jsonParser = new JsonParser();
                JsonObject jsonObject = (JsonObject)jsonParser.parse((Reader)br);
                return jsonObject.get("automation_session").getAsJsonObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private String getBasicAuthenticationEncoding() {
        String userPassword = this.username + ":" + this.accessKey;
        return new String(Base64.encodeBase64((byte[])userPassword.getBytes()));
    }

    private void getBrowserStackCredentials() {
        String url_string = ThucydidesSystemProperty.BROWSERSTACK_URL.from(this.environmentVariables);
        try {
            URL url = new URL(url_string);
            String userInfo = url.getUserInfo();
            if (userInfo.split(":").length == 2) {
                this.username = userInfo.split(":")[0].split("-")[0];
                this.accessKey = userInfo.split(":")[1];
            }
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
    }
}

