/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model;

import java.io.File;
import java.io.FilenameFilter;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Optional;
import net.serenitybdd.core.collect.NewList;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.requirements.RequirementsPath;
import net.thucydides.core.requirements.model.LoadedNarrative;
import net.thucydides.core.requirements.model.RequirementDefinition;
import net.thucydides.core.requirements.model.RequirementsConfiguration;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;
import net.thucydides.core.util.EnvironmentVariables;

public class NarrativeReader {
    private static final String BACKSLASH = "\\\\";
    private static final String FORWARDSLASH = "/";
    private final String rootDirectory;
    private final List<String> requirementTypes;

    protected NarrativeReader(String rootDirectory, List<String> requirementTypes) {
        this.rootDirectory = rootDirectory;
        this.requirementTypes = NewList.copyOf(requirementTypes);
    }

    public static NarrativeReader forRootDirectory(String rootDirectory) {
        return NarrativeReader.forRootDirectory(SystemEnvironmentVariables.currentEnvironmentVariables(), rootDirectory);
    }

    public static NarrativeReader forRootDirectory(EnvironmentVariables environmentVariables, String rootDirectory) {
        List<String> requirementTypes = new RequirementsConfiguration(environmentVariables, rootDirectory).getRequirementTypes();
        return new NarrativeReader(rootDirectory, requirementTypes);
    }

    public NarrativeReader withRequirementTypes(List<String> requirementTypes) {
        return new NarrativeReader(this.rootDirectory, requirementTypes);
    }

    public Optional<RequirementDefinition> loadFrom(File directory) {
        return this.loadFrom(directory, 0);
    }

    private int levelOf(File directory) {
        if (this.getClass().getClassLoader().getResource(this.rootDirectory) == null) {
            return 0;
        }
        try {
            String rootPath = this.getClass().getClassLoader().getResource(this.rootDirectory).toURI().getPath();
            if (directory.getPath().startsWith(rootPath)) {
                return directory.getPath().substring(rootPath.length() + 1).split(File.separator).length;
            }
        }
        catch (URISyntaxException e) {
            return 0;
        }
        return 0;
    }

    public Optional<RequirementDefinition> loadFrom(File directory, int requirementsLevel) {
        File[] narrativeFiles = directory.listFiles(this.calledNarrativeOrOverview());
        if (narrativeFiles == null || narrativeFiles.length == 0) {
            return Optional.empty();
        }
        return this.narrativeLoadedFrom(narrativeFiles[0], requirementsLevel);
    }

    public Optional<RequirementDefinition> loadFromStoryFile(File storyFile) {
        if (storyFile.getName().endsWith(".story")) {
            return this.narrativeLoadedFrom(storyFile, "story");
        }
        if (storyFile.getName().endsWith(".feature")) {
            return this.featureNarrativeLoadedFrom(storyFile);
        }
        return Optional.empty();
    }

    private Optional<RequirementDefinition> narrativeLoadedFrom(File narrativeFile, int requirementsLevel) {
        String defaultType = this.directoryLevelInRequirementsHierarchy(narrativeFile, requirementsLevel);
        return LoadedNarrative.load().fromFile(narrativeFile, defaultType);
    }

    private Optional<RequirementDefinition> narrativeLoadedFrom(File narrativeFile, String defaultType) {
        return LoadedNarrative.load().fromFile(narrativeFile, defaultType);
    }

    private Optional<RequirementDefinition> featureNarrativeLoadedFrom(File narrativeFile) {
        CucumberParser parser = new CucumberParser();
        return parser.loadFeatureDefinition(narrativeFile);
    }

    private String directoryLevelInRequirementsHierarchy(File narrativeFile, int requirementsLevel) {
        String normalizedNarrativePath = this.normalized(narrativeFile.getAbsolutePath());
        String normalizedRootPath = this.normalized(this.rootDirectory);
        int rootDirectoryStart = this.findRootDirectoryStart(normalizedNarrativePath, normalizedRootPath);
        int rootDirectoryEnd = this.findRootDirectoryEnd(rootDirectoryStart, normalizedNarrativePath, normalizedRootPath);
        String relativeNarrativePath = normalizedNarrativePath.substring(rootDirectoryEnd);
        int directoryCount = RequirementsPath.fileSystemPathElements(relativeNarrativePath).size() - 1;
        int level = this.calculateRequirementsLevel(requirementsLevel, directoryCount);
        return this.getRequirementTypeForLevel(level);
    }

    private boolean isNarrative(File narrativeFile) {
        return narrativeFile.getName().equalsIgnoreCase("readme.md") || narrativeFile.getName().equalsIgnoreCase("readme.txt") || narrativeFile.getName().toLowerCase().endsWith("narrative.txt") || narrativeFile.getName().toLowerCase().endsWith("narrative.md");
    }

    private int calculateRequirementsLevel(int requirementsLevel, int directoryCount) {
        return requirementsLevel + directoryCount - 1;
    }

    private int findRootDirectoryEnd(int rootDirectoryStart, String normalizedNarrativePath, String normalizedRootPath) {
        if (normalizedNarrativePath.contains(normalizedRootPath)) {
            return rootDirectoryStart >= 0 ? rootDirectoryStart + normalizedRootPath.length() : 0;
        }
        if (normalizedNarrativePath.contains("/stories/")) {
            return rootDirectoryStart >= 0 ? rootDirectoryStart + "/stories/".length() : 0;
        }
        if (normalizedNarrativePath.contains("/features/")) {
            return rootDirectoryStart >= 0 ? rootDirectoryStart + "/features/".length() : 0;
        }
        return 0;
    }

    private int findRootDirectoryStart(String normalizedNarrativePath, String normalizedRootPath) {
        if (normalizedNarrativePath.contains(normalizedRootPath)) {
            return normalizedNarrativePath.indexOf(normalizedRootPath);
        }
        if (normalizedNarrativePath.contains("/stories/")) {
            return normalizedNarrativePath.indexOf("/stories/");
        }
        if (normalizedNarrativePath.contains("/features/")) {
            return normalizedNarrativePath.indexOf("/features/");
        }
        return 0;
    }

    private String normalized(String path) {
        return path.replaceAll(BACKSLASH, FORWARDSLASH);
    }

    private String getRequirementTypeForLevel(int level) {
        if (level > this.requirementTypes.size() - 1) {
            return this.requirementTypes.get(this.requirementTypes.size() - 1);
        }
        return this.requirementTypes.get(level);
    }

    private FilenameFilter calledNarrativeOrOverview() {
        return (file, name) -> name.toLowerCase().equals("narrative.txt") || name.toLowerCase().equals("narrative.md") || name.toLowerCase().equals("readme.md") || name.toLowerCase().equals("overview.txt") || name.toLowerCase().equals("overview.md");
    }
}

