/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.thucydides.core.model.TestTag;

public class DataSetDescriptor {
    private final int startRow;
    private final int rowCount;
    private final String name;
    private final String description;
    private List<TestTag> tags;
    public static final DataSetDescriptor DEFAULT_DESCRIPTOR = new DataSetDescriptor(0, 0);

    public DataSetDescriptor(int startRow, int rowCount, String name, String description, List<TestTag> tags) {
        this.startRow = startRow;
        this.rowCount = rowCount;
        this.name = name;
        this.description = description;
        this.tags = new ArrayList<TestTag>(tags);
    }

    public DataSetDescriptor(int startrow, int rowCount) {
        this(startrow, rowCount, "", "", Collections.emptyList());
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getRowCount() {
        return this.rowCount;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public DataSetDescriptor withNameAndDescription(String name, String description) {
        return new DataSetDescriptor(this.startRow, this.rowCount, name, description, this.tags);
    }

    public DataSetDescriptor withRowCount(int rowCount) {
        return new DataSetDescriptor(this.startRow, rowCount, this.name, this.description, this.tags);
    }

    public void addTags(List<TestTag> tags) {
        this.tags = new ArrayList<TestTag>(tags);
    }

    public List<TestTag> getTags() {
        return this.tags == null ? Collections.emptyList() : new ArrayList<TestTag>(this.tags);
    }

    public DataSetDescriptor forRange(int startRow, int rowCount) {
        return new DataSetDescriptor(startRow, rowCount, this.name, this.description, this.tags);
    }

    public int getLastRow() {
        return this.rowCount == 0 ? this.startRow : this.startRow + this.rowCount - 1;
    }
}

