/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.model.cucumber;

import com.google.common.base.Splitter;
import io.cucumber.core.feature.FeatureParser;
import io.cucumber.core.gherkin.FeatureParserException;
import io.cucumber.core.resource.Resource;
import io.cucumber.messages.types.Background;
import io.cucumber.messages.types.Envelope;
import io.cucumber.messages.types.Examples;
import io.cucumber.messages.types.Feature;
import io.cucumber.messages.types.FeatureChild;
import io.cucumber.messages.types.GherkinDocument;
import io.cucumber.messages.types.Rule;
import io.cucumber.messages.types.RuleChild;
import io.cucumber.messages.types.Scenario;
import io.cucumber.messages.types.Tag;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.reports.html.CucumberTagConverter;
import net.thucydides.core.requirements.model.FeatureBackgroundNarrative;
import net.thucydides.core.requirements.model.RequirementDefinition;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.DescriptionWithScenarioReferences;
import net.thucydides.core.requirements.model.cucumber.InvalidFeatureFileException;
import net.thucydides.core.requirements.model.cucumber.NarrativeFromCucumberComments;
import net.thucydides.core.requirements.model.cucumber.URIResource;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CucumberParser {
    private final String locale;
    private final String encoding;
    private static final Logger LOGGER = LoggerFactory.getLogger(CucumberParser.class);

    public CucumberParser() {
        this(ConfiguredEnvironment.getEnvironmentVariables());
    }

    public CucumberParser(EnvironmentVariables environmentVariables) {
        this(ThucydidesSystemProperty.FEATURE_FILE_LANGUAGE.from(environmentVariables, "en"), environmentVariables);
    }

    public CucumberParser(String locale, EnvironmentVariables environmentVariables) {
        this.locale = locale;
        this.encoding = ThucydidesSystemProperty.FEATURE_FILE_ENCODING.from(environmentVariables, Charset.defaultCharset().name());
    }

    public Optional<AnnotatedFeature> loadFeature(File narrativeFile) {
        if (narrativeFile == null) {
            return Optional.empty();
        }
        if (!narrativeFile.exists()) {
            return Optional.empty();
        }
        ArrayList<String> listOfFiles = new ArrayList<String>();
        listOfFiles.add(narrativeFile.getAbsolutePath());
        List<GherkinDocument> gherkinDocuments = this.loadCucumberFeatures(listOfFiles);
        try {
            if (gherkinDocuments.size() == 0) {
                return Optional.empty();
            }
            GherkinDocument gherkinDocument = gherkinDocuments.get(0);
            String descriptionInComments = NarrativeFromCucumberComments.in(gherkinDocument.getComments());
            if (this.featureFileCouldNotBeReadFor(gherkinDocument.getFeature())) {
                return Optional.empty();
            }
            if (gherkinDocument.getFeature().isPresent()) {
                List<Scenario> scenarioList = ((Feature)gherkinDocument.getFeature().get()).getChildren().stream().map(FeatureChild::getScenario).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
                return Optional.of(new AnnotatedFeature((Feature)gherkinDocument.getFeature().get(), scenarioList, descriptionInComments));
            }
            return Optional.empty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return Optional.empty();
        }
    }

    private List<GherkinDocument> loadCucumberFeatures(List<String> listOfFiles) {
        for (String cucumberFile : listOfFiles) {
            this.searchForCucumberSyntaxErrorsIn(cucumberFile);
        }
        ArrayList<GherkinDocument> loadedFeatures = new ArrayList<GherkinDocument>();
        List envelopes = this.getFeatures(listOfFiles).stream().flatMap(feature -> StreamSupport.stream(feature.getParseEvents().spliterator(), false)).collect(Collectors.toList());
        List gherkinDocuments = envelopes.stream().map(o -> ((Envelope)o).getGherkinDocument()).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        for (GherkinDocument gherkinDocument : gherkinDocuments) {
            if (gherkinDocument != null && gherkinDocument.getFeature() != null && gherkinDocument.getFeature().isPresent()) {
                loadedFeatures.add(gherkinDocument);
                LOGGER.trace("Added feature {}", (Object)((Feature)gherkinDocument.getFeature().get()).getName());
                continue;
            }
            LOGGER.warn("Couldn't read the feature file: {} - it will be ignored", gherkinDocument != null ? gherkinDocument.getUri() : "<null>");
        }
        return loadedFeatures;
    }

    private void searchForCucumberSyntaxErrorsIn(String cucumberFile) {
        FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
        Path cucumberFilePath = new File(cucumberFile).toPath();
        URIResource cucumberResource = new URIResource(cucumberFilePath);
        try {
            featureParser.parseResource((Resource)cucumberResource);
        }
        catch (Throwable throwable) {
            this.reportAnyCucumberSyntaxErrorsIn(throwable);
        }
    }

    private List<io.cucumber.core.gherkin.Feature> getFeatures(List<String> paths) {
        FeatureParser featureParser = new FeatureParser(UUID::randomUUID);
        ArrayList<io.cucumber.core.gherkin.Feature> results = new ArrayList<io.cucumber.core.gherkin.Feature>();
        paths.forEach(path -> {
            Path cucumberFilePath = new File((String)path).toPath();
            URIResource cucumberResource = new URIResource(cucumberFilePath);
            Optional maybeFeature = featureParser.parseResource((Resource)cucumberResource);
            maybeFeature.ifPresent(results::add);
        });
        return results;
    }

    private void reportAnyCucumberSyntaxErrorsIn(Throwable gherkinError) {
        if (gherkinError instanceof FeatureParserException) {
            throw new InvalidFeatureFileException(gherkinError.getMessage(), gherkinError);
        }
    }

    public Optional<RequirementDefinition> loadFeatureDefinition(File featureFile) {
        Optional<AnnotatedFeature> loadedFeature = this.loadFeature(featureFile);
        if (!loadedFeature.isPresent()) {
            return Optional.empty();
        }
        Feature feature = loadedFeature.get().getFeature();
        String cardNumber = this.findCardNumberInTags(this.tagsDefinedIn(feature));
        List<String> versionNumbers = this.findVersionNumberInTags(this.tagsDefinedIn(feature));
        String title = feature.getName();
        String text = this.descriptionWithScenarioReferencesFrom(feature);
        String id = this.getIdFromName(title);
        Set requirementTags = feature.getTags().stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
        requirementTags.add(TestTag.withName(title).andType("feature"));
        HashMap<String, Collection<TestTag>> scenarioTags = new HashMap<String, Collection<TestTag>>();
        List<Scenario> scenarios = this.scenariosIn(feature);
        scenarios.forEach(scenarioDefinition -> {
            if (!scenarioDefinition.getExamples().isEmpty()) {
                List scenarioOutlineTags = scenarioDefinition.getTags();
                scenarioTags.put(scenarioDefinition.getName(), CucumberTagConverter.toSerenityTags(scenarioOutlineTags));
                List examples = scenarioDefinition.getExamples();
                for (Examples currentExample : examples) {
                    ArrayList<Tag> allExampleTags = new ArrayList<Tag>();
                    allExampleTags.addAll(scenarioOutlineTags);
                    allExampleTags.addAll(currentExample.getTags());
                    scenarioTags.put(scenarioDefinition.getName() + "_examples_at_line:" + currentExample.getLocation().getLine(), CucumberTagConverter.toSerenityTags(allExampleTags));
                }
            } else {
                scenarioTags.put(scenarioDefinition.getName(), this.tagsFrom((Scenario)scenarioDefinition));
            }
        });
        List<String> scenarioNames = scenarios.stream().map(Scenario::getName).collect(Collectors.toList());
        FeatureBackgroundNarrative background = null;
        if (this.backgroundChildIn(feature.getChildren()).isPresent()) {
            background = this.backgroundElementFrom(this.backgroundChildIn(feature.getChildren()).get().getBackground());
        }
        HashMap<String, FeatureBackgroundNarrative> ruleBackgrounds = new HashMap<String, FeatureBackgroundNarrative>();
        this.rulesIn(feature.getChildren()).forEach(rule -> {
            Optional<Background> ruleBackground = rule.getChildren().stream().map(RuleChild::getBackground).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get).findFirst();
            ruleBackground.ifPresent(value -> ruleBackgrounds.put(rule.getName(), this.backgroundElementFrom(Optional.ofNullable(value))));
        });
        return Optional.of(new RequirementDefinition(Optional.of(title), Optional.of(id), Optional.ofNullable(cardNumber), versionNumbers, "feature", text != null ? text : "", new ArrayList<TestTag>(requirementTags), scenarioNames, scenarioTags).withBackground(background).withRuleBackgrounds(ruleBackgrounds));
    }

    private List<Scenario> scenariosIn(Feature feature) {
        ArrayList<Scenario> scenarios = new ArrayList<Scenario>();
        feature.getChildren().forEach(child -> {
            if (child.getRule() != null && child.getRule().isPresent()) {
                scenarios.addAll(this.scenariosIn((Rule)child.getRule().get()));
            } else if (child.getScenario() != null && child.getScenario().isPresent()) {
                scenarios.add((Scenario)child.getScenario().get());
            }
        });
        return scenarios;
    }

    private List<Scenario> scenariosIn(Rule rule) {
        return rule.getChildren().stream().filter(child -> child.getScenario() != null).map(RuleChild::getScenario).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
    }

    private Stream<Rule> rulesIn(List<FeatureChild> childrenList) {
        return childrenList.stream().map(FeatureChild::getRule).filter(Objects::nonNull).filter(Optional::isPresent).map(Optional::get);
    }

    private Optional<FeatureChild> backgroundChildIn(List<FeatureChild> featureChildren) {
        return featureChildren.stream().filter(featureChild -> featureChild.getBackground() != null).findFirst();
    }

    private FeatureBackgroundNarrative backgroundElementFrom(Optional<Background> background) {
        if (background.isPresent()) {
            return new FeatureBackgroundNarrative(background.get().getName(), background.get().getDescription());
        }
        return new FeatureBackgroundNarrative("", "");
    }

    private Collection<TestTag> tagsFrom(Scenario scenarioDefinition) {
        if (scenarioDefinition.getExamples().size() == 0) {
            return this.asSerenityTags(scenarioDefinition.getTags());
        }
        HashSet<TestTag> outlineTags = new HashSet<TestTag>(this.asSerenityTags(scenarioDefinition.getTags()));
        scenarioDefinition.getExamples().forEach(examples -> outlineTags.addAll(this.asSerenityTags(examples.getTags())));
        return outlineTags;
    }

    private Set<TestTag> asSerenityTags(List<Tag> gherkinTags) {
        return gherkinTags.stream().map(tag -> TestTag.withValue(tag.getName())).collect(Collectors.toSet());
    }

    private String descriptionWithScenarioReferencesFrom(Feature feature) {
        if (feature.getDescription() == null) {
            return "";
        }
        return Arrays.stream(feature.getDescription().split("\\r?\\n")).map(line -> DescriptionWithScenarioReferences.from(feature).forText((String)line)).collect(Collectors.joining(System.lineSeparator()));
    }

    private String getIdFromName(String name) {
        return name.replaceAll("[\\s_]", "-").toLowerCase();
    }

    private boolean featureFileCouldNotBeReadFor(Optional<Feature> feature) {
        return feature == null || !feature.isPresent();
    }

    private List<Tag> tagsDefinedIn(Feature feature) {
        return feature.getTags();
    }

    private String findCardNumberInTags(List<Tag> tags) {
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@issue:")) {
                return tag.getName().replaceAll("@issue:", "");
            }
            if (!tag.getName().toLowerCase().startsWith("@issues:")) continue;
            String issueNumberList = tag.getName().replaceAll("@issues:", "");
            List issueNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)issueNumberList);
            return (String)issueNumberTags.get(0);
        }
        return null;
    }

    private List<String> findVersionNumberInTags(List<Tag> tags) {
        ArrayList<String> versionNumbers = new ArrayList<String>();
        for (Tag tag : tags) {
            if (tag.getName().toLowerCase().startsWith("@version:")) {
                versionNumbers.add(tag.getName().replaceAll("@version:", ""));
                continue;
            }
            if (!tag.getName().toLowerCase().startsWith("@versions:")) continue;
            String versionNumberList = tag.getName().replaceAll("@versions:", "");
            List versionNumberTags = Splitter.on((String)",").trimResults().omitEmptyStrings().splitToList((CharSequence)versionNumberList);
            versionNumbers.addAll(versionNumberTags);
        }
        return versionNumbers;
    }
}

