/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.model;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import net.serenitybdd.core.reporting.ReportDirectories;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestStep;
import net.thucydides.core.screenshots.ScreenshotAndHtmlSource;

public class FailureDetails {
    private final TestOutcome testOutcome;

    public FailureDetails(TestOutcome testOutcome) {
        this.testOutcome = testOutcome;
    }

    public String getConciseErrorMessage() {
        if (this.testOutcome.firstStepWithErrorMessage().isPresent()) {
            return this.testOutcome.firstStepWithErrorMessage().get().getConciseErrorMessage();
        }
        return this.testOutcome.testFailureMessage().orElse("");
    }

    public String getCompleteErrorMessage() {
        if (this.testOutcome.firstStepWithErrorMessage().isPresent()) {
            return this.testOutcome.firstStepWithErrorMessage().get().getErrorMessage();
        }
        return this.testOutcome.testFailureMessage().orElse("");
    }

    public boolean pageSourceExists() {
        String pageSourceLink = this.getPageSourceLink();
        ReportDirectories reportDirectories = new ReportDirectories();
        return pageSourceLink != null && Files.exists(reportDirectories.getReportDirectory().resolve(pageSourceLink), new LinkOption[0]);
    }

    public String getPageSourceLink() {
        for (TestStep testStep : this.testOutcome.getFlattenedTestSteps()) {
            for (ScreenshotAndHtmlSource screenshot : testStep.getScreenshots()) {
                if (screenshot.getHtmlSourceName() == null) continue;
                return screenshot.getHtmlSourceName();
            }
        }
        return "#";
    }
}

