/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.templates;

import freemarker.core.Environment;
import freemarker.core.ParseException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import net.thucydides.core.reports.templates.ReportTemplate;
import net.thucydides.core.reports.templates.TemplateMergeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FreemarkerReportTemplate
implements ReportTemplate {
    private final Template template;
    private static final Logger LOGGER = LoggerFactory.getLogger(FreemarkerReportTemplate.class);

    public FreemarkerReportTemplate(Configuration configuration, String templateFile) throws IOException, TemplateMergeException {
        try {
            this.template = configuration.getTemplate(templateFile);
        }
        catch (ParseException parseException) {
            throw new TemplateMergeException("Parsing error in template", (Exception)((Object)parseException));
        }
    }

    @Override
    public void merge(Map<String, Object> context, Writer writer) throws TemplateMergeException {
        try {
            Environment environment = this.template.createProcessingEnvironment(context, writer);
            environment.setOutputEncoding(StandardCharsets.UTF_8.name());
            environment.setTemplateExceptionHandler((te, env, out) -> {
                LOGGER.warn("Report generation failed", (Throwable)te);
                throw te;
            });
            environment.process();
        }
        catch (TemplateException templateException) {
            LOGGER.error("Syntax error in report template: {}\n{}", (Object)templateException.getMessage(), (Object)templateException.getFTLInstructionStack());
            throw new TemplateMergeException("Failed to process FreeMarker template", (Exception)((Object)templateException));
        }
        catch (IOException e) {
            throw new TemplateMergeException("Could not read FreeMarker template", e);
        }
        catch (NumberFormatException e) {
            throw new TemplateMergeException("Number format exception during template merge", e);
        }
    }
}

