/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.requirements.reports.ExampleOutcome;

public class ExampleOutcomes {
    public static List<ExampleOutcome> from(TestOutcome outcome) {
        if (outcome.isDataDriven()) {
            return outcome.getTestSteps().stream().map(testStep -> new ExampleOutcome(ExampleOutcomes.stepTitleIn(testStep.getDescription()), ExampleOutcomes.stepSubtitleIn(testStep.getDescription()), testStep.getResult(), testStep.getStartTime(), testStep.getDuration(), testStep.getChildren().size())).collect(Collectors.toList());
        }
        return new ArrayList<ExampleOutcome>();
    }

    private static String stepTitleIn(String description) {
        return description.contains("({") ? description.substring(0, description.indexOf("({")) : description;
    }

    private static String stepSubtitleIn(String description) {
        return description.contains("({") ? ExampleOutcomes.trimmedDescription(description.substring(description.indexOf("({"))) : "";
    }

    private static String trimmedDescription(String description) {
        int parametersStart = description.indexOf("{") + 1;
        int parametersEnd = description.lastIndexOf("}");
        return description.substring(parametersStart, parametersEnd);
    }
}

