/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports.cucumber;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.thucydides.core.requirements.model.cucumber.AnnotatedFeature;
import net.thucydides.core.requirements.model.cucumber.CucumberParser;

public class FeatureCache {
    private static final FeatureCache FEATURE_CACHE = new FeatureCache();
    private final CucumberParser parser = new CucumberParser();
    private Map<File, Optional<AnnotatedFeature>> loadedFiles = new HashMap<File, Optional<AnnotatedFeature>>();

    public static FeatureCache getCache() {
        return FEATURE_CACHE;
    }

    public Optional<AnnotatedFeature> loadFeature(File featureFile) {
        if (this.loadedFiles.containsKey(featureFile)) {
            return this.loadedFiles.get(featureFile);
        }
        Optional<AnnotatedFeature> feature = this.parser.loadFeature(featureFile);
        this.loadedFiles.put(featureFile, feature);
        return feature;
    }
}

