/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.environment;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.util.EnvironmentVariables;

public class TestLocalEnvironmentVariables {
    static final ThreadLocal<Map<String, String>> THREAD_LOCAL_PROPERTIES = ThreadLocal.withInitial(ConcurrentHashMap::new);
    private static final ThreadLocal<EnvironmentVariables> CURRENT_ENVIRONMENT_VARIABLES = ThreadLocal.withInitial(SystemEnvironmentVariables::createEnvironmentVariables);
    private static final ThreadLocal<EnvironmentVariables> BASE_ENVIRONMENT_VARIABLES = ThreadLocal.withInitial(SystemEnvironmentVariables::createEnvironmentVariables);

    public static void setProperty(String name, String value) {
        THREAD_LOCAL_PROPERTIES.get().put(name, value);
        CURRENT_ENVIRONMENT_VARIABLES.set(TestLocalEnvironmentVariables.updatedEnvironmentVariables(CURRENT_ENVIRONMENT_VARIABLES.get()));
    }

    public static String getProperty(String name) {
        return THREAD_LOCAL_PROPERTIES.get().get(name);
    }

    public static Map<String, String> getProperties() {
        return new HashMap<String, String>(THREAD_LOCAL_PROPERTIES.get());
    }

    private static EnvironmentVariables updatedEnvironmentVariables(EnvironmentVariables baseEnvironmentVariables) {
        EnvironmentVariables environmentVariables = baseEnvironmentVariables.copy();
        TestLocalEnvironmentVariables.getProperties().forEach((key, value) -> environmentVariables.setProperty((String)key, environmentVariables.injectSystemPropertiesInto((String)value)));
        return environmentVariables;
    }

    public static void clear() {
        THREAD_LOCAL_PROPERTIES.get().clear();
        CURRENT_ENVIRONMENT_VARIABLES.set(BASE_ENVIRONMENT_VARIABLES.get());
    }

    public static EnvironmentVariables getUpdatedEnvironmentVariables() {
        return CURRENT_ENVIRONMENT_VARIABLES.get();
    }
}

