/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.digest.Digest;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.util.NameConverter;

public class ReportNamer {
    private ReportType type;
    private boolean compressedFilename;
    private String prefix = "";

    public static ReportNamer forReportType(ReportType type) {
        return new ReportNamer(type);
    }

    private ReportNamer(ReportType type) {
        this(type, ThucydidesSystemProperty.SERENITY_COMPRESS_FILENAMES.booleanFrom(ConfiguredEnvironment.getEnvironmentVariables(), true));
    }

    public ReportNamer(ReportType type, boolean compressedFilename) {
        this.type = type;
        this.compressedFilename = compressedFilename;
    }

    public String getNormalizedReportNameFor(TestOutcome testOutcome) {
        String testName = this.getBaseTestNameFor(testOutcome);
        String testNameWithoutIndex = NameConverter.stripIndexesFrom(testName);
        return this.normalizedVersionOf(NameConverter.filesystemSafe(testNameWithoutIndex));
    }

    public String getNormalizedTestReportNameFor(String testName) {
        String testNameWithoutIndex = NameConverter.stripIndexesFrom(testName);
        return this.normalizedVersionOf(NameConverter.filesystemSafe(testNameWithoutIndex));
    }

    public String optionallyCompressed(String text) {
        return this.compressedFilename ? Digest.ofTextValue(text) : Digest.ofTextValue(text, this.shortened(text));
    }

    private String shortened(String text) {
        return text.substring(Math.max(0, text.length() - 30));
    }

    private String getBaseTestNameFor(TestOutcome testOutcome) {
        if (this.isJUnit5(testOutcome.getQualifiedId())) {
            return testOutcome.getUserStory().getId() + "." + testOutcome.getMethodName();
        }
        String pathWithoutSlashes = testOutcome.getPath() != null ? testOutcome.getPath().replace(".", "_").replace("/", "_SL_") : "";
        return NameConverter.withNoIssueNumbers(pathWithoutSlashes + "." + testOutcome.getQualifiedId());
    }

    private boolean isJUnit5(String qualifiedId) {
        return qualifiedId.startsWith("[engine:");
    }

    public String getSimpleTestNameFor(TestOutcome testOutcome) {
        return this.optionallyCompressed(this.appendSuffixTo(NameConverter.withNoIssueNumbers(testOutcome.getQualifiedId())));
    }

    public String getNormalizedReportNameFor(Story userStory) {
        return this.getNormalizedReportNameFor(userStory.getName());
    }

    public String getNormalizedReportNameFor(String name) {
        return this.normalizedVersionOf(NameConverter.underscore(name.toLowerCase()));
    }

    private String normalizedVersionOf(String text) {
        return this.prefix + this.appendSuffixTo(this.optionallyCompressed(text));
    }

    private String appendSuffixTo(String testNameWithUnderscores) {
        if (this.type == ReportType.ROOT) {
            return testNameWithUnderscores;
        }
        return testNameWithUnderscores + "." + this.type.toString();
    }

    public ReportNamer withNoCompression() {
        return new ReportNamer(this.type, false);
    }

    public ReportNamer withPrefix(String prefix) {
        this.prefix = prefix;
        return this;
    }
}

