/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.io;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import net.serenitybdd.core.time.SystemClock;
import net.thucydides.core.guice.Injectors;

public class SafelyMoveFiles {
    public static final int DELAY_BETWEEN_FILE_ACCESSES_IN_MS = 500;
    private final Path origin;
    private final int maxRetries;
    private final SystemClock clock;

    public SafelyMoveFiles(Path origin, int maxRetries) {
        this.origin = origin;
        this.maxRetries = maxRetries;
        this.clock = (SystemClock)Injectors.getInjector().getInstance(SystemClock.class);
    }

    public static SafelyMoveFilesBuilder withMaxRetriesOf(int maxRetries) {
        return new SafelyMoveFilesBuilder(maxRetries);
    }

    public Path to(Path destination) throws IOException {
        try {
            if (Files.exists(destination, new LinkOption[0])) {
                return destination;
            }
            return Files.move(this.origin, destination, StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
        }
        catch (NoSuchFileException fileAlreadyMoved) {
            return destination;
        }
        catch (IOException e) {
            if (this.maxRetries == 0) {
                throw e;
            }
            this.clock.pauseFor(500L);
            return SafelyMoveFiles.withMaxRetriesOf(this.maxRetries - 1).from(this.origin).to(destination);
        }
    }

    public static class SafelyMoveFilesBuilder {
        private final int maxRetries;

        public SafelyMoveFilesBuilder(int maxRetries) {
            this.maxRetries = maxRetries;
        }

        public SafelyMoveFiles from(Path origin) {
            return new SafelyMoveFiles(origin, this.maxRetries);
        }
    }
}

