/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.requirements.reports.CompoundDuration;

public class ExampleOutcome {
    private final String title;
    private final String subtitle;
    private final TestResult result;
    private ZonedDateTime startTime;
    private final long duration;
    private final long stepCount;

    public ExampleOutcome(String title, String subtitle, TestResult result, ZonedDateTime startTime, long duration, long stepCount) {
        this.title = title;
        this.subtitle = subtitle;
        this.result = result;
        this.startTime = startTime;
        this.duration = duration;
        this.stepCount = stepCount;
    }

    public String getTitle() {
        return this.title;
    }

    public boolean hasSubtitle() {
        return this.subtitle != null && !this.subtitle.isEmpty();
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public TestResult getResult() {
        return this.result;
    }

    public ZonedDateTime getStartTime() {
        return this.startTime;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getStepCount() {
        return this.stepCount;
    }

    public String getFormattedStartTime() {
        return this.startTime != null ? "" + this.startTime.format(DateTimeFormatter.ofPattern("HH:mm:ss")) : "";
    }

    public String getFormattedDuration() {
        return this.duration != 0L ? "" + CompoundDuration.of(this.duration) : "";
    }
}

