/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.json.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Optional;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.flags.Flag;
import net.thucydides.core.reports.json.AScenarioHasNoNameException;
import net.thucydides.core.reports.json.JSONConverter;
import net.thucydides.core.reports.json.gson.ClassTypeAdapter;
import net.thucydides.core.reports.json.gson.CollectionAdapter;
import net.thucydides.core.reports.json.gson.FileDeserializer;
import net.thucydides.core.reports.json.gson.FileSerializer;
import net.thucydides.core.reports.json.gson.InterfaceAdapter;
import net.thucydides.core.reports.json.gson.OptionalTypeAdapter;
import net.thucydides.core.reports.json.gson.StackTraceElementDeserializer;
import net.thucydides.core.reports.json.gson.StackTraceElementSerializer;
import net.thucydides.core.reports.json.gson.ZonedDateTimeAdapter;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class GsonJSONConverter
implements JSONConverter {
    private final EnvironmentVariables environmentVariables;
    private final Gson gson;
    private final String encoding;

    protected Gson getGson() {
        return this.gson;
    }

    @Inject
    public GsonJSONConverter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.encoding = ThucydidesSystemProperty.SERENITY_REPORT_ENCODING.from(environmentVariables, StandardCharsets.UTF_8.name());
        GsonBuilder gsonBuilder = new GsonBuilder().registerTypeAdapterFactory(OptionalTypeAdapter.FACTORY).registerTypeHierarchyAdapter(Collection.class, (Object)new CollectionAdapter()).registerTypeAdapter(Flag.class, new InterfaceAdapter()).registerTypeAdapter(StackTraceElement.class, (Object)new StackTraceElementSerializer()).registerTypeAdapter(StackTraceElement.class, (Object)new StackTraceElementDeserializer()).registerTypeAdapter(ZonedDateTime.class, (Object)new ZonedDateTimeAdapter()).registerTypeAdapter(File.class, (Object)new FileSerializer()).registerTypeAdapter(File.class, (Object)new FileDeserializer()).registerTypeAdapter(Class.class, (Object)new ClassTypeAdapter());
        this.gson = this.usePrettyPrinting() ? gsonBuilder.setPrettyPrinting().create() : gsonBuilder.create();
    }

    @Override
    public Optional<TestOutcome> fromJson(InputStream inputStream) throws IOException {
        return this.fromJson(new InputStreamReader(inputStream, this.encoding));
    }

    @Override
    public Optional<TestOutcome> fromJson(Reader jsonReader) {
        TestOutcome testOutcome = (TestOutcome)this.gson.fromJson(jsonReader, TestOutcome.class);
        return this.isValid(testOutcome) ? Optional.of(testOutcome) : Optional.empty();
    }

    private boolean isValid(TestOutcome testOutcome) {
        if (testOutcome == null || StringUtils.isEmpty((CharSequence)testOutcome.getId())) {
            return false;
        }
        this.checkForRequiredFieldsIn(testOutcome);
        return true;
    }

    private void checkForRequiredFieldsIn(TestOutcome testOutcome) {
        if (StringUtils.isEmpty((CharSequence)testOutcome.getName())) {
            throw new AScenarioHasNoNameException(testOutcome.getId());
        }
    }

    @Override
    public void toJson(TestOutcome testOutcome, OutputStream outputStream) throws IOException {
        testOutcome.calculateDynamicFieldValues();
        try (OutputStreamWriter out = new OutputStreamWriter(outputStream, this.encoding);){
            this.gson.toJson((Object)testOutcome, (Appendable)out);
        }
    }

    private boolean usePrettyPrinting() {
        return Boolean.parseBoolean(ThucydidesSystemProperty.JSON_PRETTY_PRINTING.from(this.environmentVariables, "false"));
    }
}

