/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.thucydides.core.guice.ThucydidesModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Injectors {
    private static final Logger LOGGER = LoggerFactory.getLogger(Injectors.class);
    private static final Map<String, Injector> injectors = new ConcurrentHashMap<String, Injector>();
    private static volatile Module defaultModule;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Injector getInjector() {
        if (defaultModule != null) return Injectors.getInjector(defaultModule);
        Class<Injectors> clazz = Injectors.class;
        synchronized (Injectors.class) {
            if (defaultModule != null) return Injectors.getInjector(defaultModule);
            defaultModule = new ThucydidesModule();
            // ** MonitorExit[var0] (shouldn't be in output)
            return Injectors.getInjector(defaultModule);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Injector getInjector(Module module) {
        String moduleClassName = module.getClass().getCanonicalName();
        Injector injector = injectors.get(moduleClassName);
        if (injector != null) return injector;
        Class<Injectors> clazz = Injectors.class;
        synchronized (Injectors.class) {
            injector = injectors.get(moduleClassName);
            if (injector != null) return injector;
            injector = Guice.createInjector((Module[])new Module[]{module});
            injectors.put(moduleClassName, injector);
            LOGGER.debug("Created injector for module {}", (Object)moduleClassName);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return injector;
        }
    }
}

