/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class TestClassHierarchy {
    private static final TestClassHierarchy INSTANCE = new TestClassHierarchy();
    private final Map<String, String> classPathToDisplayName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> idToDisplayName = new ConcurrentHashMap<String, String>();
    private final Map<String, String> idToParent = new ConcurrentHashMap<String, String>();

    public static TestClassHierarchy getInstance() {
        return INSTANCE;
    }

    public void testSuiteStarted(String className, String uniqueIdentifier, String displayName, String parentUniqueIdentifier) {
        this.idToDisplayName.put(uniqueIdentifier, displayName);
        this.classPathToDisplayName.put(className, displayName);
        if (parentUniqueIdentifier != null) {
            this.idToParent.put(uniqueIdentifier, parentUniqueIdentifier);
        }
    }

    public Optional<String> displayNameFor(String path) {
        return Optional.ofNullable(this.classPathToDisplayName.get(path));
    }
}

