/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.tags;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.requirements.reports.RequirementsOutcomes;

public class BreadcrumbTagFilter {
    private final RequirementsService requirementsService;

    public BreadcrumbTagFilter(RequirementsService requirementsService) {
        this.requirementsService = requirementsService;
    }

    public BreadcrumbTagFilter() {
        this((RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class));
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(TestOutcome testOutcome) {
        ArrayList<TestTag> ancestors = new ArrayList<TestTag>();
        this.requirementsService.getParentRequirementFor(testOutcome).ifPresent(requirement -> {
            ancestors.add(requirement.asTag());
            this.requirementsService.getParentRequirementsOf((Requirement)requirement).forEach(parent -> ancestors.add(parent.asTag()));
        });
        return ancestors;
    }

    private Requirement last(List<Requirement> ancestors) {
        return ancestors.isEmpty() ? null : ancestors.get(ancestors.size() - 1);
    }

    private List<TestTag> tagsForParentRequirements(List<Requirement> parents) {
        return parents.stream().map(requirement -> TestTag.withName(requirement.getDisplayName()).andType(requirement.getType())).collect(Collectors.toList());
    }

    public List<TestTag> getRequirementBreadcrumbsFrom(RequirementsOutcomes requirementsOutcomes) {
        ArrayList<TestTag> breadcrumbs = new ArrayList<TestTag>();
        if (requirementsOutcomes.getParentRequirement().isPresent()) {
            breadcrumbs.add(requirementsOutcomes.getParentRequirement().get().asTag());
        }
        return breadcrumbs;
    }
}

