/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.buildinfo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.DirectoryIteratorException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import net.serenitybdd.core.buildinfo.DriverCapabilityRecord;
import net.thucydides.core.webdriver.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyBasedDriverCapabilityRecord
implements DriverCapabilityRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyBasedDriverCapabilityRecord.class);
    private Configuration configuration;

    public PropertyBasedDriverCapabilityRecord(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public void registerCapabilities(String driver, Properties capabilitiesAsProperties) {
        try {
            File browserProperties = new File(this.configuration.getOutputDirectory(), "browser-" + driver.toLowerCase() + ".properties");
            try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(browserProperties), StandardCharsets.UTF_8.toString());){
                capabilitiesAsProperties.store(writer, "");
            }
        }
        catch (IOException e) {
            LOGGER.warn("Failed to store browser configuration for " + capabilitiesAsProperties);
        }
    }

    @Override
    public List<String> getDrivers() {
        ArrayList<String> drivers = new ArrayList<String>();
        try (DirectoryStream<Path> stream = this.driverCapabilityRecords();){
            for (Path file : stream) {
                drivers.add(this.driverNameFrom(file));
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            LOGGER.error("Exception during getting drivers", (Throwable)x);
        }
        return drivers;
    }

    private String driverNameFrom(Path file) {
        return file.getFileName().toString().replace("browser-", "").replace(".properties", "");
    }

    private DirectoryStream<Path> driverCapabilityRecords() throws IOException {
        Path outputDirectory = this.configuration.getOutputDirectory().toPath();
        return Files.newDirectoryStream(outputDirectory, "browser-*.properties");
    }

    @Override
    public Map<String, Properties> getDriverCapabilities() {
        HashMap<String, Properties> driverCapabilities = new HashMap<String, Properties>();
        try (DirectoryStream<Path> stream = this.driverCapabilityRecords();){
            for (Path file : stream) {
                String driverName = this.driverNameFrom(file);
                Properties driverProperties = new Properties();
                try (InputStream properties = Files.newInputStream(file, new OpenOption[0]);){
                    driverProperties.load(properties);
                }
                driverCapabilities.put(driverName, driverProperties);
            }
        }
        catch (IOException | DirectoryIteratorException x) {
            LOGGER.error("Exception during getting driver capabilities", (Throwable)x);
        }
        return driverCapabilities;
    }
}

