/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.core.history;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.serenitybdd.core.collect.NewSet;
import net.serenitybdd.core.history.NewFailure;
import net.serenitybdd.core.history.PreviousTestOutcome;
import net.serenitybdd.core.history.TestOutcomeSummaryRecorder;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestResult;
import net.thucydides.core.model.flags.Flag;
import net.thucydides.core.model.flags.FlagProvider;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class HistoricalFlagProvider
implements FlagProvider {
    private final EnvironmentVariables environmentVariables;
    private final Map<String, PreviousTestOutcome> previousTestOutcomesById;
    private final Set<? extends Flag> NO_FLAGS = NewSet.of();

    public HistoricalFlagProvider(EnvironmentVariables environmentVariables, TestOutcomeSummaryRecorder summaryRecorder) {
        this.environmentVariables = environmentVariables;
        List<PreviousTestOutcome> previousOutcomes = summaryRecorder.loadSummaries();
        this.previousTestOutcomesById = this.indexById(previousOutcomes);
    }

    private Map<String, PreviousTestOutcome> indexById(List<PreviousTestOutcome> previousOutcomes) {
        HashMap<String, PreviousTestOutcome> previousTestOutcomesById = new HashMap<String, PreviousTestOutcome>();
        for (PreviousTestOutcome previousTestOutcome : previousOutcomes) {
            previousTestOutcomesById.put(previousTestOutcome.getId(), previousTestOutcome);
        }
        return previousTestOutcomesById;
    }

    @Override
    public Set<? extends Flag> getFlagsFor(TestOutcome testOutcome) {
        if (!this.historicalFlagsAreActivated()) {
            return NewSet.of();
        }
        return this.newFailureIn(testOutcome) ? NewSet.of(NewFailure.FLAG) : this.NO_FLAGS;
    }

    private boolean newFailureIn(TestOutcome testOutcome) {
        if (this.isUnknownTest(testOutcome)) {
            return false;
        }
        if (this.isNotBroken(testOutcome)) {
            return false;
        }
        PreviousTestOutcome previousTestOutcome = this.previousTestOutcomesById.get(testOutcome.getId());
        if (this.resultIsDifferent(testOutcome, previousTestOutcome)) {
            return true;
        }
        return this.causeIsDifferent(testOutcome, previousTestOutcome);
    }

    private boolean isUnknownTest(TestOutcome testOutcome) {
        return !this.previousTestOutcomesById.containsKey(testOutcome.getId());
    }

    private boolean isNotBroken(TestOutcome testOutcome) {
        return testOutcome.getResult() == TestResult.SUCCESS || testOutcome.getResult() == TestResult.IGNORED || testOutcome.getResult() == TestResult.PENDING || testOutcome.getResult() == TestResult.SKIPPED;
    }

    private boolean causeIsDifferent(TestOutcome testOutcome, PreviousTestOutcome previousTestOutcome) {
        return !StringUtils.equals((CharSequence)testOutcome.getTestFailureSummary(), (CharSequence)previousTestOutcome.getTestFailureSummary());
    }

    private boolean resultIsDifferent(TestOutcome testOutcome, PreviousTestOutcome previousTestOutcome) {
        return testOutcome.getResult() != previousTestOutcome.getResult();
    }

    private boolean historicalFlagsAreActivated() {
        return ThucydidesSystemProperty.SHOW_HISTORY_FLAGS.booleanFrom(this.environmentVariables, false);
    }
}

