/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.model;

import com.google.common.base.Splitter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.serenitybdd.core.strings.FirstLine;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.annotations.AnnotatedDescription;
import net.thucydides.core.annotations.Feature;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.model.AnnotatedStoryTitle;
import net.thucydides.core.model.PathElement;
import net.thucydides.core.model.PathElements;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Stories;
import net.thucydides.core.model.TestClassHierarchy;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.features.ApplicationFeature;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.model.FeatureType;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class Story {
    private String id;
    private String storyName;
    private String displayName;
    private String storyClassName;
    private String path;
    private PathElements pathElements;
    private String parentName;
    private String narrative;
    private ApplicationFeature feature;
    private String type;
    private TestTag singleParentTag;

    protected Story(Class<?> userStoryClass) {
        this.id = userStoryClass.getCanonicalName();
        this.storyClassName = userStoryClass.getName();
        this.storyName = userStoryClass.getSimpleName();
        this.displayName = AnnotatedStoryTitle.forClass(userStoryClass).orElse(userStoryClass.getSimpleName());
        this.feature = this.findFeatureFrom(userStoryClass);
        this.path = Story.pathOf(userStoryClass);
        this.narrative = AnnotatedDescription.forClass(userStoryClass).orElse("");
        this.pathElements = this.pathElementsFromPackagePath(this.path);
        this.type = FeatureType.FEATURE.toString();
    }

    private PathElements pathElementsFromPackagePath(String path) {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        String configuredRootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables, "");
        String rootPath = "";
        if (StringUtils.isNotEmpty((CharSequence)configuredRootPath) && path.startsWith(configuredRootPath)) {
            path = path.equals(configuredRootPath) ? "" : path.substring(configuredRootPath.length() + 1);
            rootPath = configuredRootPath;
        }
        if (path == null) {
            return PathElements.from(new ArrayList<PathElement>());
        }
        List pathElementNames = Splitter.onPattern((String)"\\.|\\$").omitEmptyStrings().splitToList((CharSequence)path);
        String cumulatedPath = "";
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        for (String pathElement : pathElementNames) {
            cumulatedPath = cumulatedPath + "." + pathElement;
            String completePath = rootPath + cumulatedPath;
            String displayName = this.displayNameOfPathElement(completePath, pathElement);
            pathElements.add(new PathElement(pathElement, displayName));
        }
        return PathElements.from(pathElements);
    }

    private String displayNameOfPathElement(String completePath, String pathElement) {
        return TestClassHierarchy.getInstance().displayNameFor(completePath).orElse(pathElement);
    }

    private PathElements pathElementsFromDirectoryPath(String path) {
        ArrayList<PathElement> pathElements = new ArrayList<PathElement>();
        if (path != null) {
            Path storyPath = Paths.get(path, new String[0]);
            for (int i = 0; i < storyPath.getNameCount(); ++i) {
                pathElements.add(new PathElement(storyPath.getName(i).toString(), ""));
            }
        }
        return PathElements.from(pathElements);
    }

    public static String pathOf(Class<?> userStoryClass) {
        String canonicalName = userStoryClass.getCanonicalName();
        return Story.stripRootPathFrom(canonicalName);
    }

    public static String completePathOf(Class<?> userStoryClass) {
        String canonicalName = userStoryClass.getCanonicalName();
        int lastDot = canonicalName.lastIndexOf(".");
        int lastDollar = canonicalName.lastIndexOf("$");
        int lastSeparator = Math.max(lastDollar, lastDot);
        if (lastSeparator > 0) {
            return canonicalName.substring(0, lastSeparator);
        }
        return "";
    }

    private static String stripRootPathFrom(String testOutcomePath) {
        EnvironmentVariables environmentVariables = SystemEnvironmentVariables.currentEnvironmentVariables();
        if (testOutcomePath == null) {
            return "";
        }
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private ApplicationFeature findFeatureFrom(Class<?> userStoryClass) {
        if (Story.getFeatureClass(userStoryClass) != null) {
            return ApplicationFeature.from(Story.getFeatureClass(userStoryClass));
        }
        return null;
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, ApplicationFeature feature) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = this.normalisedPath(path);
        this.pathElements = this.pathElementsFromDirectoryPath(this.path);
        this.narrative = null;
        this.type = FeatureType.FEATURE.toString();
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, PathElements pathElements, ApplicationFeature feature, String narrative) {
        this(id, storyName, storyClassName, displayName, path, pathElements, feature, narrative, FeatureType.FEATURE.toString());
    }

    public Story(String id, String storyName, String storyClassName, String displayName, String path, PathElements pathElements, ApplicationFeature feature, String narrative, String type) {
        this.id = id;
        this.storyName = storyName;
        this.storyClassName = storyClassName;
        this.displayName = displayName;
        this.feature = feature;
        this.path = path;
        this.pathElements = pathElements;
        this.narrative = narrative;
        this.type = type;
    }

    protected Story(String id, String storyName, String displayName, ApplicationFeature feature, String path) {
        this.id = id;
        this.storyName = storyName;
        this.displayName = displayName;
        this.storyClassName = null;
        this.feature = feature;
        this.path = this.normalisedPath(path);
        this.pathElements = this.pathElementsFromDirectoryPath(this.path);
        this.type = FeatureType.FEATURE.toString();
    }

    public String getId() {
        return this.id;
    }

    public static Story from(Class<?> userStoryClass) {
        return new Story(userStoryClass);
    }

    public static Story withId(String storyId, String storyName) {
        return new Story(storyId, storyName, null, null, null);
    }

    public Story withNarrative(String narrative) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.pathElements, this.feature, narrative, this.type);
    }

    public Story withType(String type) {
        return new Story(this.id, this.storyName, this.storyClassName, this.displayName, this.path, this.pathElements, this.feature, this.narrative, type);
    }

    public static Story withIdAndPath(String storyId, String storyName, String storyPath) {
        return new Story(storyId, storyName, null, storyName, storyPath, null);
    }

    public Story withDisplayName(String name) {
        this.displayName = name;
        return this;
    }

    public Story withStoryName(String name) {
        this.storyName = name;
        return this;
    }

    public static Story called(String storyName) {
        return new Story(storyName, storyName, null, null, null);
    }

    public static Story withId(String storyId, String storyName, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), null);
    }

    public static Story withIdAndPathAndFeature(String storyId, String storyName, String storyPath, String featureClassName, String featureName) {
        return new Story(storyId, storyName, storyName, new ApplicationFeature(featureClassName, featureName), storyPath);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Story)) {
            return false;
        }
        Story story = (Story)o;
        if (!this.id.equals(story.id)) {
            return false;
        }
        return Objects.equals(this.path, story.path);
    }

    public int hashCode() {
        int result = this.id.hashCode();
        result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
        return result;
    }

    public static Class<?> getFeatureClass(Class<?> userStoryClass) {
        Class<?> enclosingClass;
        if (userStoryClass != null && Story.isAFeature(enclosingClass = userStoryClass.getEnclosingClass())) {
            return enclosingClass;
        }
        return null;
    }

    private static boolean isAFeature(Class<?> enclosingClass) {
        return enclosingClass != null && enclosingClass.getAnnotation(Feature.class) != null;
    }

    public static Class<?> testedInTestCase(Class<?> testClass) {
        net.thucydides.core.annotations.Story story = testClass.getAnnotation(net.thucydides.core.annotations.Story.class);
        if (story != null) {
            return story.value();
        }
        return null;
    }

    public String getName() {
        return this.storyName;
    }

    public String getDisplayName() {
        return StringUtils.isNotEmpty((CharSequence)this.displayName) ? this.displayName : this.storyName;
    }

    public String getStoryClassName() {
        return this.storyClassName;
    }

    public String getReportName(ReportType type) {
        return Stories.reportFor(this, type);
    }

    public String getReportName() {
        return new ReportNameProvider().forRequirement(this.asTag());
    }

    public ApplicationFeature getFeature() {
        return this.feature;
    }

    public String getPath() {
        if (this.pathElements == null || this.pathElements.isEmpty()) {
            return this.path;
        }
        return this.pathElements.asPath();
    }

    public String getRelativePath(List<String> rootElements) {
        if (this.pathElements.isEmpty()) {
            return this.path;
        }
        return this.pathElements.asPath();
    }

    public PathElements getParentPathElements() {
        return this.pathElements;
    }

    public PathElements getPathElements() {
        return this.pathElements;
    }

    public String getStoryName() {
        return this.storyName;
    }

    public String getNarrative() {
        return this.narrative;
    }

    public String getNarrativeSummary() {
        return FirstLine.of(this.narrative);
    }

    public String getType() {
        return this.type;
    }

    public Story withPath(String path) {
        this.path = path;
        this.type = FeatureType.forFilename(path).toString();
        return this;
    }

    public Story asFeature() {
        this.type = FeatureType.FEATURE.toString();
        return this;
    }

    public TestTag asTag() {
        return this.asQualifiedTag();
    }

    public TestTag asQualifiedTag() {
        if (this.getPathElements() == null) {
            return TestTag.withName(this.storyName).andType(this.type);
        }
        String qualifiedName = this.getPathElements().stream().map(PathElement::getName).collect(Collectors.joining("/"));
        return TestTag.withName(qualifiedName).andType(this.type).withDisplayName(this.getDisplayName());
    }

    public TestTag asSingleParentTag() {
        if (this.singleParentTag == null) {
            String lastElementOfPath = this.getParentPathElements() == null || this.getParentPathElements().isEmpty() ? "" : ((PathElement)this.getParentPathElements().get(this.getParentPathElements().size() - 1)).getName();
            this.singleParentTag = StringUtils.isNotEmpty((CharSequence)lastElementOfPath) ? TestTag.withName(lastElementOfPath + "/" + this.storyName).andType(this.type) : TestTag.withName(this.storyName).andType(this.type);
        }
        return this.singleParentTag;
    }

    private String normalisedPath(String path) {
        if (path == null) {
            return path;
        }
        String normalisedPath = path;
        if (normalisedPath.startsWith("classpath:features/")) {
            normalisedPath = normalisedPath.substring("classpath:features/".length());
        }
        if (normalisedPath.endsWith(".feature") || normalisedPath.endsWith(".story")) {
            normalisedPath = normalisedPath.substring(0, normalisedPath.lastIndexOf("."));
        }
        return normalisedPath;
    }
}

