/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import com.google.common.base.Splitter;
import java.util.List;
import net.serenitybdd.core.di.ModelInfrastructure;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.environment.SystemEnvironmentVariables;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;

public class ReportOptions {
    private final boolean showStepDetails;
    private final boolean showManualTests;
    private final boolean showReleases;
    private final boolean showProgress;
    private final boolean showHistory;
    private final boolean showTagMenus;
    private final boolean showRelatedTags;
    private final String projectName;
    private final String projectSubTitle;
    private final RequirementsService requirementsService;
    private final boolean displayPiechart;
    private final List<String> firstClassTagTypes;

    public static ReportOptions forEnvironment(EnvironmentVariables environmentVariables) {
        return new ReportOptions(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public ReportOptions(EnvironmentVariables environmentVariables) {
        this(environmentVariables, ModelInfrastructure.getRequirementsService());
    }

    public ReportOptions(EnvironmentVariables environmentVariables, RequirementsService requirementsService) {
        this.showStepDetails = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORTS_SHOW_STEP_DETAILS.from(environmentVariables, "false"));
        this.showManualTests = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORT_SHOW_MANUAL_TESTS.from(environmentVariables, "true"));
        this.showReleases = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORT_SHOW_RELEASES.from(environmentVariables, "false"));
        this.showProgress = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORT_SHOW_PROGRESS.from(environmentVariables, "false"));
        this.showHistory = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORT_SHOW_HISTORY.from(environmentVariables, "false"));
        this.showTagMenus = Boolean.parseBoolean(ThucydidesSystemProperty.SERENITY_REPORT_SHOW_TAG_MENUS.from(environmentVariables, "false"));
        this.showRelatedTags = Boolean.parseBoolean(ThucydidesSystemProperty.SHOW_RELATED_TAGS.from(environmentVariables, "true"));
        this.displayPiechart = Boolean.parseBoolean(ThucydidesSystemProperty.SHOW_PIE_CHARTS.from(environmentVariables, "true"));
        this.projectName = ThucydidesSystemProperty.SERENITY_PROJECT_NAME.from(environmentVariables, "Serenity BDD Report");
        this.projectSubTitle = ThucydidesSystemProperty.REPORT_SUBTITLE.from(environmentVariables, "");
        this.requirementsService = requirementsService;
        this.firstClassTagTypes = Splitter.on((String)",").omitEmptyStrings().splitToList((CharSequence)ThucydidesSystemProperty.SERENITY_REPORT_TAG_MENUS.from(environmentVariables, ""));
    }

    public List<String> getFirstClassTagTypes() {
        return this.firstClassTagTypes;
    }

    public boolean isShowStepDetails() {
        return this.showStepDetails;
    }

    public boolean isShowManualTests() {
        return this.showManualTests;
    }

    public boolean isShowReleases() {
        return this.showReleases && !this.requirementsService.getReleasesFromRequirements().isEmpty();
    }

    public boolean isShowProgress() {
        return this.showProgress;
    }

    public boolean isShowHistory() {
        return this.showHistory;
    }

    public boolean isShowTagMenus() {
        return this.showTagMenus;
    }

    public boolean isShowRelatedTags() {
        return this.showRelatedTags;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public String getProjectSubTitle() {
        return this.projectSubTitle;
    }

    public boolean isDisplayPiechart() {
        return this.displayPiechart;
    }
}

