/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements;

import java.util.List;
import net.serenitybdd.core.di.ModelInfrastructure;
import net.serenitybdd.core.environment.ConfiguredEnvironment;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.requirements.FileSystemRequirementsService;
import net.thucydides.core.requirements.Requirements;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.reports.FileSystemRequirmentsOutcomeFactory;
import net.thucydides.core.requirements.reports.RequirementsOutcomeFactory;

public class FileSystemRequirements
implements Requirements {
    private final RequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirmentsOutcomeFactory;

    public FileSystemRequirements(String path) {
        this.requirementsService = new FileSystemRequirementsService(path);
        this.requirmentsOutcomeFactory = new FileSystemRequirmentsOutcomeFactory(ConfiguredEnvironment.getEnvironmentVariables(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()), path);
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirmentsOutcomeFactory;
    }

    @Override
    public RequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

