/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.requirements.reports;

import net.thucydides.core.requirements.reports.SubrequirementsCount;

public class SubrequirementsProportionCount {
    private final SubrequirementsCount subrequirementsCount;

    public SubrequirementsProportionCount(SubrequirementsCount subrequirementsCount) {
        this.subrequirementsCount = subrequirementsCount;
    }

    public double withResult(String resultValue) {
        long totalNumberOfRequirements = this.subrequirementsCount.getTotal();
        long requirementsWithExpectedResult = this.subrequirementsCount.withResult(resultValue);
        if (totalNumberOfRequirements == 0L) {
            return 0.0;
        }
        return (double)requirementsWithExpectedResult / (double)totalNumberOfRequirements;
    }

    public double withSkippedOrIgnored() {
        long totalNumberOfRequirements = this.subrequirementsCount.getTotal();
        long requirementsWithExpectedResult = this.subrequirementsCount.withResult("skipped") + this.subrequirementsCount.withResult("ignored");
        if (totalNumberOfRequirements == 0L) {
            return 0.0;
        }
        return (double)requirementsWithExpectedResult / (double)totalNumberOfRequirements;
    }

    public double withNoTests() {
        long totalNumberOfRequirements = this.subrequirementsCount.getTotal();
        long requirementsWithNoTests = this.subrequirementsCount.withNoTests();
        if (totalNumberOfRequirements == 0L) {
            return 0.0;
        }
        return (double)requirementsWithNoTests / (double)totalNumberOfRequirements;
    }
}

