/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers.dates;

import java.util.Date;
import net.thucydides.model.matchers.dates.DateMatcherFormatter;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;

public class DateIsBetweenMatcher
extends TypeSafeMatcher<Date> {
    private final DateTime startDate;
    private final DateTime endDate;

    public DateIsBetweenMatcher(Date startDate, Date endDate) {
        this.startDate = new DateTime((Object)startDate);
        this.endDate = new DateTime((Object)endDate);
    }

    public boolean matchesSafely(Date date) {
        DateTime provided = new DateTime((Object)date);
        return !(!provided.isEqual((ReadableInstant)this.startDate) && !provided.isAfter((ReadableInstant)this.startDate) || !provided.isEqual((ReadableInstant)this.endDate) && !provided.isBefore((ReadableInstant)this.endDate));
    }

    public void describeTo(Description description) {
        description.appendText("a date that is between ");
        description.appendText(DateMatcherFormatter.formatted(this.startDate));
        description.appendText(" and ");
        description.appendText(DateMatcherFormatter.formatted(this.endDate));
    }
}

