/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Function;
import java.util.function.Supplier;
import net.thucydides.model.domain.PathElements;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.requirements.model.Requirement;

public class RequirementCache {
    private volatile List<Requirement> requirements;
    private final List<Requirement> flattenedRequirements = new CopyOnWriteArrayList<Requirement>();
    private final Map<String, Requirement> requirementsPathIndex;
    private final Map<TestTag, Requirement> requirementsByTag;
    private final Set<Requirement> flattenedRequirementsSet = ConcurrentHashMap.newKeySet();

    private RequirementCache() {
        this.requirementsPathIndex = new ConcurrentHashMap<String, Requirement>();
        this.requirementsByTag = new ConcurrentHashMap<TestTag, Requirement>();
    }

    public void clear() {
        this.requirements = null;
        this.flattenedRequirements.clear();
        this.flattenedRequirementsSet.clear();
        this.requirementsPathIndex.clear();
        this.requirementsByTag.clear();
    }

    public static RequirementCache getInstance() {
        return SingletonHelper.INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Requirement> getRequirements(Supplier<List<Requirement>> requirementFactory) {
        if (this.requirements == null) {
            RequirementCache requirementCache = this;
            synchronized (requirementCache) {
                if (this.requirements == null) {
                    this.requirements = requirementFactory.get();
                }
            }
        }
        return this.requirements;
    }

    public void indexRequirements(Map<PathElements, Requirement> requirementsByPath) {
        requirementsByPath.forEach((path, requirement) -> this.requirementsPathIndex.put(requirement.getPath(), (Requirement)requirement));
    }

    public Map<String, Requirement> getRequirementsPathIndex() {
        return this.requirementsPathIndex;
    }

    public Requirement getRequirementsByTag(TestTag testTag, Function<TestTag, Requirement> requirementFinder) {
        return this.requirementsByTag.computeIfAbsent(testTag, requirementFinder);
    }

    public void updateFlattenedRequirements(List<Requirement> requirements) {
        requirements.forEach(requirement -> {
            if (!this.flattenedRequirementsSet.contains(requirement)) {
                this.flattenedRequirements.add((Requirement)requirement);
                this.flattenedRequirementsSet.add((Requirement)requirement);
            }
        });
    }

    public List<Requirement> getRequirements() {
        return this.requirements;
    }

    public List<Requirement> getFlattenedRequirements() {
        return new ArrayList<Requirement>(this.flattenedRequirements);
    }

    private static class SingletonHelper {
        private static final RequirementCache INSTANCE = new RequirementCache();

        private SingletonHelper() {
        }
    }
}

