/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.statistics.service;

import com.google.common.base.Splitter;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.requirements.CoreTagProvider;
import net.thucydides.model.statistics.service.TagProvider;
import net.thucydides.model.util.EnvironmentVariables;

public class InjectedTagProvider
implements TagProvider,
CoreTagProvider {
    EnvironmentVariables environmentVariables;

    public InjectedTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public InjectedTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        String injectedTagValues = ThucydidesSystemProperty.INJECTED_TAGS.from(this.environmentVariables, "");
        if (injectedTagValues.isEmpty()) {
            return new HashSet<TestTag>();
        }
        List tags = Splitter.on((String)",").trimResults().splitToList((CharSequence)injectedTagValues);
        return tags.stream().map(TestTag::withValue).collect(Collectors.toSet());
    }
}

