/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.collections4.IteratorUtils;
import org.apache.commons.lang3.StringUtils;

public class ExampleTable {
    private static final String NEWLINE_CHAR = "\u2424";
    private static final String NEWLINE = "\u0085";
    private static final String LINE_SEPARATOR = "\u2028";
    private static final String PARAGRAPH_SEPARATOR = "\u2089";
    private static final String LEFT_BRACKET = "\u0ff3B";
    private static final String RIGHT_BRACKET = "\u0ff3D";
    List<String> headers;
    List<List<String>> rows = new ArrayList<List<String>>();
    static final Pattern NEW_LINE = Pattern.compile("(\\r\\n)|(\\n)|(\\r)|(\u2424)|(\u2028)|(\u2089)|(\\r\u2424)");
    private static final String SQUARE_BRACKETS_OR_WHITE_SPACE = "[]\u0ff3B\u0ff3D\t";

    public ExampleTable(String tableContents) {
        tableContents = ExampleTable.stripBracketsFromOuterPipes(tableContents);
        List lines = IteratorUtils.toList(Splitter.on((Pattern)NEW_LINE).omitEmptyStrings().trimResults(CharMatcher.anyOf((CharSequence)SQUARE_BRACKETS_OR_WHITE_SPACE)).split((CharSequence)tableContents).iterator());
        this.addHeaderFrom((String)lines.get(0));
        for (int row = 1; row < lines.size(); ++row) {
            this.addRowFrom((String)lines.get(row));
        }
    }

    public static String stripBracketsFromOuterPipes(String text) {
        text = StringUtils.replace((String)text, (String)"[|", (String)"|");
        text = StringUtils.replace((String)text, (String)"\uff3b|", (String)"|");
        text = StringUtils.replace((String)text, (String)"|]", (String)"|");
        text = StringUtils.replace((String)text, (String)"|\uff3d", (String)"|");
        text = StringUtils.replace((String)text, (String)"\u0ff3B|", (String)"|");
        text = StringUtils.replace((String)text, (String)"|\u0ff3D", (String)"|");
        return text;
    }

    private void addRowFrom(String row) {
        this.rows.add(this.cellsFrom(row));
    }

    private void addHeaderFrom(String headerLine) {
        this.headers = this.cellsFrom(headerLine);
    }

    private List<String> cellsFrom(String line) {
        if ((line = line.trim()).startsWith("|")) {
            line = line.substring(1);
        }
        if (line.endsWith("|")) {
            line = line.substring(0, line.length() - 1);
        }
        return IteratorUtils.toList(Splitter.on((String)"|").trimResults().split((CharSequence)line).iterator());
    }

    public String inHtmlFormat() {
        if (this.rows.size() == 0) {
            return this.singleRowTable();
        }
        if (this.headers.size() == 1) {
            return this.tabularList();
        }
        return this.tableWithHeaderAndRows();
    }

    private String singleRowTable() {
        return "<table class='embedded'>" + this.getHtmlBody(Arrays.asList(this.headers)) + "</table>";
    }

    private String tabularList() {
        ArrayList<List<String>> allRows = new ArrayList<List<String>>();
        allRows.add(this.headers);
        allRows.addAll(this.rows);
        return "<table class='embedded'>" + this.getHtmlBody(allRows) + "</table>";
    }

    private String tableWithHeaderAndRows() {
        return "<table class='embedded'>" + this.getHtmlHeader() + this.getHtmlBody(this.rows) + "</table>";
    }

    public String getHtmlHeader() {
        StringBuilder htmlHeader = new StringBuilder();
        String headerElement = this.headers.size() > 1 ? "th" : "td";
        htmlHeader.append("<thead>");
        for (String header : this.headers) {
            htmlHeader.append("<").append(headerElement).append(">").append(header).append("</" + headerElement + ">");
        }
        htmlHeader.append("</thead>");
        return htmlHeader.toString();
    }

    public String getHtmlBody(List<List<String>> rows) {
        StringBuffer htmlBody = new StringBuffer();
        htmlBody.append("<tbody>");
        for (List<String> row : rows) {
            htmlBody.append("<tr>");
            for (String cell : row) {
                htmlBody.append("<td>").append(cell).append("</td>");
            }
            htmlBody.append("</tr>");
        }
        htmlBody.append("</tbody>");
        return htmlBody.toString();
    }
}

