/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.domain.Release;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.releases.ReleaseManager;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.AllRequirements;
import net.thucydides.model.requirements.ParentRequirementsProvided;
import net.thucydides.model.requirements.ReleaseProvider;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.RequirementsConfiguration;
import net.thucydides.model.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseRequirementsService
implements RequirementsService {
    protected List<Requirement> requirements;
    protected List<Release> releases;
    private Map<Requirement, List<Requirement>> requirementAncestors;
    protected final EnvironmentVariables environmentVariables;
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRequirementsService.class);
    private final Map<TestOutcome, Optional> parentRequirementCache = new HashMap<TestOutcome, Optional>();
    private ReleaseManager releaseManager;
    private List<String> requirementTypes;
    private static final List<Requirement> NO_PARENTS = new ArrayList<Requirement>();

    public BaseRequirementsService(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    @Override
    public abstract List<Requirement> getRequirements();

    public abstract List<? extends RequirementsTagProvider> getRequirementsTagProviders();

    public abstract Optional<ReleaseProvider> getReleaseProvider();

    @Override
    public Optional<Requirement> getParentRequirementFor(TestOutcome testOutcome) {
        if (!this.parentRequirementCache.containsKey(testOutcome)) {
            this.parentRequirementCache.put(testOutcome, this.findParentRequirementFor(testOutcome));
        }
        return this.parentRequirementCache.get(testOutcome);
    }

    private Optional<Requirement> findParentRequirementFor(TestOutcome testOutcome) {
        for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
            Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, requirementsTagProvider);
            if (!requirement.isPresent()) continue;
            return requirement;
        }
        return Optional.empty();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag tag) {
        try {
            for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
                Optional<Requirement> requirement = requirementsTagProvider.getRequirementFor(tag);
                if (!requirement.isPresent()) continue;
                return requirement;
            }
        }
        catch (RuntimeException handleTagProvidersElegantly) {
            LOGGER.error("Tag provider failure", (Throwable)handleTagProvidersElegantly);
        }
        return Optional.empty();
    }

    @Override
    public List<Requirement> getAncestorRequirementsFor(TestOutcome testOutcome) {
        for (RequirementsTagProvider requirementsTagProvider : this.getRequirementsTagProviders()) {
            Optional<Requirement> requirement = this.getParentRequirementOf(testOutcome, requirementsTagProvider);
            if (!requirement.isPresent()) continue;
            LOGGER.trace("Requirement found for test outcome " + testOutcome.getTitle() + "-" + String.valueOf(testOutcome.getIssueKeys()) + ": " + String.valueOf(requirement));
            Optional<Requirement> matchingAncestor = this.matchingAncestorFor(requirement.get());
            if (matchingAncestor.isPresent()) {
                return this.getRequirementAncestors().get(matchingAncestor.get());
            }
            LOGGER.warn("Requirement without identified ancestors found test outcome " + testOutcome.getTitle() + "-" + String.valueOf(testOutcome.getIssueKeys()) + ": " + String.valueOf(requirement));
        }
        return Collections.EMPTY_LIST;
    }

    Optional<Requirement> matchingAncestorFor(Requirement requirement) {
        return this.getRequirementAncestors().keySet().stream().filter(requirementKey -> requirementKey.matches(requirement)).findFirst();
    }

    protected void indexRequirements() {
        this.requirementAncestors = new ConcurrentHashMap<Requirement, List<Requirement>>();
        for (Requirement requirement : this.requirements) {
            List<Requirement> requirementPath = NewList.of(requirement);
            this.requirementAncestors.put(requirement, NewList.of(requirement));
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    private void indexChildRequirements(List<Requirement> ancestors, List<Requirement> children) {
        for (Requirement requirement : children) {
            ArrayList<Requirement> requirementPath = new ArrayList<Requirement>(ancestors);
            requirementPath.add(requirement);
            this.requirementAncestors.put(requirement, NewList.copyOf(requirementPath));
            this.indexChildRequirements(requirementPath, requirement.getChildren());
        }
    }

    private ReleaseManager getReleaseManager() {
        if (this.releaseManager == null) {
            ReportNameProvider defaultNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, (RequirementsService)this);
            this.releaseManager = new ReleaseManager(this.environmentVariables, defaultNameProvider, this);
        }
        return this.releaseManager;
    }

    private Map<Requirement, List<Requirement>> getRequirementAncestors() {
        if (this.requirementAncestors == null) {
            this.getRequirements();
        }
        return this.requirementAncestors;
    }

    private Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome, RequirementsTagProvider tagProvider) {
        Optional<Requirement> parentDefinedInTags = ParentRequirementsProvided.by(tagProvider).forOutcome(testOutcome);
        if (parentDefinedInTags.isPresent()) {
            Optional<Requirement> matchingIndexedParentRequirement = this.findMatchingIndexedRequirement(parentDefinedInTags.get());
            return matchingIndexedParentRequirement;
        }
        return Optional.empty();
    }

    private Optional<Requirement> findMatchingIndexedRequirement(Requirement requirement) {
        return AllRequirements.asStreamFrom(this.requirements).filter(requirement::matches).map(matchingRequirement -> this.mostPreciseOf(requirement, (Requirement)matchingRequirement)).findFirst();
    }

    private Requirement mostPreciseOf(Requirement thisRequirement, Requirement thatRequirement) {
        String thisParent = thisRequirement.getParent() != null ? thisRequirement.getParent() : "";
        String thatParent = thatRequirement.getParent() != null ? thatRequirement.getParent() : "";
        return thatParent.length() >= thisParent.length() ? thatRequirement : thisRequirement;
    }

    @Override
    public List<Release> getReleasesFromRequirements() {
        if (this.releases == null) {
            if (this.getReleaseProvider().isPresent() && this.getReleaseProvider().get().isActive()) {
                this.releases = this.getReleaseProvider().get().getReleases();
            } else {
                List<List<String>> releaseVersions = this.getReleaseVersionsFrom(this.getRequirements());
                this.releases = this.getReleaseManager().extractReleasesFrom(releaseVersions);
            }
        }
        return this.releases;
    }

    @Override
    public List<String> getRequirementTypes() {
        if (this.requirementTypes == null) {
            this.requirementTypes = this.requirementTypesDefinedIn(this.getRequirements()).stream().distinct().collect(Collectors.toList());
        }
        return this.requirementTypes;
    }

    private Set<String> allTypesIn(List<Requirement> requirements) {
        HashSet<String> flattenedRequirements = new HashSet<String>();
        requirements.forEach(requirement -> {
            flattenedRequirements.add(requirement.getType());
            if (requirement.getChildren() != null) {
                flattenedRequirements.addAll(this.allTypesIn(requirement.getChildren()));
            }
        });
        return flattenedRequirements;
    }

    private Collection<String> requirementTypesDefinedIn(List<Requirement> requirements) {
        RequirementsConfiguration requirementsConfiguration = new RequirementsConfiguration(this.environmentVariables);
        List<String> configuredRequirementTypes = requirementsConfiguration.getRequirementTypes();
        ArrayList<String> requirementTypes = new ArrayList<String>();
        Set<String> allRequirementTypes = this.allTypesIn(requirements);
        for (String configuredRequirementType : configuredRequirementTypes) {
            if (!allRequirementTypes.contains(configuredRequirementType)) continue;
            requirementTypes.add(configuredRequirementType);
        }
        for (Requirement requirement : requirements) {
            if (!requirementTypes.contains(requirement.getType())) {
                requirementTypes.add(requirement.getType());
            }
            if (requirement.getChildren().isEmpty()) continue;
            requirementTypes.addAll(this.childRequirementTypesDefinedIn(requirement.getChildren()));
        }
        return requirementTypes;
    }

    private Collection<String> childRequirementTypesDefinedIn(List<Requirement> requirements) {
        ArrayList<String> requirementTypes = new ArrayList<String>();
        for (Requirement requirement : requirements) {
            if (!requirementTypes.contains(requirement.getType())) {
                requirementTypes.add(requirement.getType());
            }
            if (requirement.getChildren().isEmpty()) continue;
            requirementTypes.addAll(this.childRequirementTypesDefinedIn(requirement.getChildren()));
        }
        return requirementTypes;
    }

    private Collection<TestTag> requirementTagsOfType(List<Requirement> requirements, List<String> tagTypes) {
        return AllRequirements.asStreamFrom(requirements).map(requirement -> this.tagsWithTypes((Requirement)requirement, tagTypes)).flatMap(Function.identity()).collect(Collectors.toList());
    }

    private Stream<TestTag> tagsWithTypes(Requirement requirement, List<String> tagTypes) {
        return requirement.getTags().stream().filter(tag -> tagTypes.contains(tag.getType()));
    }

    @Override
    public List<String> getReleaseVersionsFor(TestOutcome testOutcome) {
        ArrayList<String> releases = new ArrayList<String>(testOutcome.getVersions());
        for (Requirement parentRequirement : this.getAncestorRequirementsFor(testOutcome)) {
            releases.addAll(parentRequirement.getReleaseVersions());
        }
        return releases;
    }

    private List<List<String>> getReleaseVersionsFrom(List<Requirement> requirements) {
        ArrayList<List<String>> releaseVersions = new ArrayList<List<String>>();
        for (Requirement requirement : requirements) {
            releaseVersions.add(requirement.getReleaseVersions());
            releaseVersions.addAll(this.getReleaseVersionsFrom(requirement.getChildren()));
        }
        return releaseVersions;
    }

    @Override
    public boolean isRequirementsTag(TestTag tag) {
        return this.getRequirementTypes().contains(tag.getType());
    }

    @Override
    public Collection<TestTag> getTagsOfType(List<String> tagTypes) {
        return this.requirementTagsOfType(this.getRequirements(), tagTypes);
    }

    @Override
    public Collection<Requirement> getRequirementsWithTagsOfType(List<String> tagTypes) {
        return AllRequirements.asStreamFrom(this.requirements).filter(requirement -> this.hasTagOfType((Requirement)requirement, tagTypes)).collect(Collectors.toList());
    }

    private boolean hasTagOfType(Requirement requirement, List<String> tagTypes) {
        return requirement.getTags().stream().anyMatch(tag -> tagTypes.contains(tag.getType()));
    }

    @Override
    public boolean containsEmptyRequirementWithTag(TestTag tag) {
        return AllRequirements.asStreamFrom(this.requirements).anyMatch(requirement -> requirement.hasTag(tag) && requirement.containsNoScenarios());
    }

    @Override
    public void resetRequirements() {
        this.requirements = null;
    }

    @Override
    public List<Requirement> getParentRequirementsOf(Requirement requirement) {
        List<Requirement> ancestors = this.requirementAncestors.get(requirement);
        return ancestors == null || ancestors.isEmpty() ? NO_PARENTS : ancestors.subList(0, ancestors.size() - 1);
    }
}

