/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.requirements.reports.ScenarioOutcome;

public class ScenarioResultCounts {
    private final List<ScenarioOutcome> scenarios;

    public ScenarioResultCounts(List<ScenarioOutcome> scenarios) {
        this.scenarios = scenarios;
    }

    public static ScenarioResultCounts forScenarios(List<ScenarioOutcome> scenarios) {
        List<ScenarioOutcome> mainScenarios = scenarios.stream().filter(scenarioOutcome -> !scenarioOutcome.isBackground()).collect(Collectors.toList());
        return new ScenarioResultCounts(mainScenarios);
    }

    public String byTypeFor(String ... testResultTypes) {
        ArrayList<String> resultCounts = new ArrayList<String>();
        for (String resultType : testResultTypes) {
            resultCounts.add(this.labeledValue(resultType));
        }
        return Arrays.toString(resultCounts.toArray());
    }

    private String labeledValue(String resultType) {
        TestResult expectedResult = TestResult.valueOf(resultType.toUpperCase());
        long resultCount = this.getOverallTestCount(expectedResult);
        String label = TestResult.valueOf(resultType.toUpperCase()).getLabel();
        return "{meta: '" + label + "', value: " + resultCount + "}";
    }

    public long getOverallTestCount(TestResult expectedResult) {
        return this.scenarios.stream().filter(scenarioOutcome -> scenarioOutcome.getResult() == expectedResult).count();
    }

    public String percentageLabelsByTypeFor(String ... testResultTypes) {
        ArrayList<CallSite> resultLabels = new ArrayList<CallSite>();
        int totalTestCount = this.scenarios.size();
        for (String resultType : testResultTypes) {
            TestResult expectedResult = TestResult.valueOf(resultType.toUpperCase());
            double percentageResult = this.getOverallTestPercentage(expectedResult) * 100 / totalTestCount;
            resultLabels.add((CallSite)((Object)("'" + this.percentageLabelFor(percentageResult) + "'")));
        }
        return Arrays.toString(resultLabels.toArray());
    }

    private String percentageLabelFor(double value) {
        return value > 0.0 ? Math.round(value) + "%" : " ";
    }

    public String getOverallTestPercentageLabel(String result) {
        TestResult expectedResult = TestResult.valueOf(result.toUpperCase());
        return this.percentageLabelFor(this.getOverallTestPercentage(expectedResult).intValue());
    }

    public Integer getOverallTestPercentage(TestResult expectedResult) {
        return (int)Math.round((double)this.getOverallTestCount(expectedResult) * 100.0 / (double)this.scenarios.size());
    }
}

