/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.reports.html;

import com.google.common.base.Splitter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.EnvironmentSpecificConfiguration;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.reports.html.TagExclusions;
import net.thucydides.model.reports.html.TagMatch;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class TagFilter {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirementsService;
    private final List<String> excludedTags;
    private final List<String> ALWAYS_HIDDEN_TAGS = Arrays.asList("manual-result", "manual-test-evidence", "manual-last-tested", "singlebrowser", "Duration");

    public TagFilter() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public TagFilter(EnvironmentVariables environmentVariables) {
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.environmentVariables = environmentVariables;
        this.excludedTags = new ArrayList<String>(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.SERENITY_REPORT_EXCLUDE_TAGS));
        this.excludedTags.addAll(EnvironmentSpecificConfiguration.from(environmentVariables).getListOfValues(ThucydidesSystemProperty.HIDDEN_TAGS));
        this.excludedTags.addAll(this.ALWAYS_HIDDEN_TAGS);
    }

    public List<String> filteredTagTypes(List<String> tagTypes) {
        List<String> filteredTags = new ArrayList<String>(tagTypes);
        List<String> displayedTags = this.includedTagTypes();
        if (!displayedTags.isEmpty()) {
            filteredTags = this.onlyKeepAllowedTypes(filteredTags, displayedTags);
        }
        ArrayList<String> excludedTags = new ArrayList<String>(this.excludedTagTypes());
        excludedTags.addAll(this.ALWAYS_HIDDEN_TAGS);
        return this.nonExcludedTags(this.removeUnwantedTags(filteredTags, excludedTags));
    }

    public boolean shouldDisplayTagWithType(String tagType) {
        return !this.filteredTagTypes(Collections.singletonList(tagType)).isEmpty();
    }

    public boolean shouldDisplayTag(TestTag tag) {
        TagExclusions exclusions = TagExclusions.usingEnvironment(this.environmentVariables);
        return exclusions.doNotExclude(tag);
    }

    public Set<TestTag> removeTagsOfType(Set<TestTag> tags, String ... redundantTagTypes) {
        HashSet<TestTag> filteredTags = new HashSet<TestTag>();
        List<String> maskedTagTypes = Arrays.asList(redundantTagTypes);
        for (TestTag tag : tags) {
            if (maskedTagTypes.contains(tag.getType())) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    public Set<TestTag> removeTagsWithName(Set<TestTag> tags, String name) {
        HashSet<TestTag> filteredTags = new HashSet<TestTag>();
        for (TestTag tag : tags) {
            if (tag.getShortName().equalsIgnoreCase(name)) continue;
            filteredTags.add(tag);
        }
        return filteredTags;
    }

    private List<String> onlyKeepAllowedTypes(List<String> tags, List<String> displayedTags) {
        ArrayList<String> allowedTags = new ArrayList<String>();
        for (String tag : tags) {
            if (!displayedTags.contains(tag.toLowerCase())) continue;
            allowedTags.add(tag);
        }
        return allowedTags;
    }

    private List<String> removeUnwantedTags(List<String> tags, List<String> unwantedTags) {
        for (String tag : unwantedTags) {
            tags.remove(tag.toLowerCase());
            tags.remove(tag.toUpperCase());
        }
        return tags;
    }

    private List<String> nonExcludedTags(List<String> tags) {
        TagExclusions exclusions = TagExclusions.usingEnvironment(this.environmentVariables);
        return tags.stream().filter(tag -> exclusions.doNotExclude(TestTag.withValue(tag))).collect(Collectors.toList());
    }

    private List<String> includedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> excludedTagTypes() {
        return this.asLowercaseList(ThucydidesSystemProperty.DASHBOARD_EXCLUDED_TAG_LIST.from(this.environmentVariables));
    }

    private List<String> asLowercaseList(String displayTags) {
        if (StringUtils.isNotEmpty((CharSequence)displayTags)) {
            return Splitter.on((String)",").omitEmptyStrings().trimResults().splitToList((CharSequence)displayTags.toLowerCase());
        }
        return new ArrayList<String>();
    }

    public Set<TestTag> removeHiddenTagsFrom(Collection<TestTag> filteredTags) {
        List hiddenTypes = this.requirementsService.getRequirementTypes().stream().map(type -> type + ":*").collect(Collectors.toList());
        hiddenTypes.addAll(this.excludedTags);
        return filteredTags.stream().filter(tag -> this.doNotExclude((TestTag)tag, hiddenTypes)).collect(Collectors.toSet());
    }

    private boolean doNotExclude(TestTag tag, List<String> hiddenTagExpressions) {
        return hiddenTagExpressions.stream().noneMatch(hiddenTagExpression -> TagMatch.excluding(hiddenTagExpression).matches(tag));
    }

    public Set<String> rawTagTypes() {
        return new HashSet<String>(this.asLowercaseList(ThucydidesSystemProperty.REPORT_RAW_TAG_LIST.from(this.environmentVariables)));
    }
}

