/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.buildinfo;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class BuildProperties {
    private final Map<String, String> generalProperties;
    private final List<String> drivers;
    private final Map<String, Properties> driverProperties;
    private final Map<String, Map<String, String>> sections;

    public BuildProperties(Map<String, String> generalProperties, List<String> drivers, Map<String, Properties> driverProperties, Map<String, Map<String, String>> sections) {
        this.generalProperties = generalProperties;
        this.drivers = drivers;
        this.driverProperties = driverProperties;
        this.sections = this.sorted(sections);
    }

    private Map<String, Map<String, String>> sorted(Map<String, Map<String, String>> sections) {
        TreeMap<String, Map<String, String>> sortedSections = new TreeMap<String, Map<String, String>>();
        sections.forEach((key, section) -> {
            TreeMap sortedSectionProperties = new TreeMap(section);
            sortedSections.put((String)key, sortedSectionProperties);
        });
        return sortedSections;
    }

    public Map<String, String> getGeneralProperties() {
        return new TreeMap<String, String>(this.generalProperties);
    }

    public List<String> getDrivers() {
        return new ArrayList<String>(this.drivers);
    }

    public Map<String, Properties> getDriverProperties() {
        return new TreeMap<String, Properties>(this.driverProperties);
    }

    public List<String> getSectionTitles() {
        return this.sections.keySet().stream().sorted().collect(Collectors.toList());
    }

    public Map<String, Map<String, String>> getSections() {
        return this.sections;
    }
}

