/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.util;

import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.text.StringSubstitutor;

public class PropertiesUtil {
    public static Properties copyOf(Properties sourceProperties) {
        Properties copiedProperties = new Properties();
        for (String propertyName : sourceProperties.stringPropertyNames()) {
            if (sourceProperties.getProperty(propertyName) == null) continue;
            copiedProperties.setProperty(propertyName, sourceProperties.getProperty(propertyName));
        }
        return copiedProperties;
    }

    public static void expandPropertyAndEnvironmentReferences(Map<String, String> runnerEnvironmentVariables, Properties properties) {
        Set<String> names = properties.stringPropertyNames();
        for (String name : names) {
            String value = properties.getProperty(name);
            String expandedValue = StringSubstitutor.replaceSystemProperties((Object)value);
            expandedValue = StringSubstitutor.replace((Object)expandedValue, runnerEnvironmentVariables);
            properties.setProperty(name, expandedValue);
        }
    }
}

