/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import com.google.common.base.Splitter;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.PathElement;
import net.thucydides.model.domain.PathElements;
import net.thucydides.model.domain.RequirementCache;
import net.thucydides.model.domain.Story;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.reports.TestOutcomeLoader;
import net.thucydides.model.requirements.OverridableTagProvider;
import net.thucydides.model.requirements.RequirementTypesProvider;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.RequirementsConfiguration;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.Inflector;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

public class TestOutcomeRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider,
RequirementTypesProvider {
    public static final String JUNIT5_FORMAT = "JUnit5";
    public static final String JUNIT4_FORMAT = "JUnit";
    public static final String JAVASCRIPT_FORMAT = "JS";
    public static final String DEFAULT_TARGET_DIR = "target/site/serenity";
    private final RequirementsConfiguration requirementsConfiguration;
    private final EnvironmentVariables environmentVariables;
    private static final List<String> SUPPORTED_TEST_SOURCES = NewList.of("JUnit5", "JUnit", "JS");
    private Path sourceDirectory;

    public TestOutcomeRequirementsTagProvider() {
        this(ModelInfrastructure.getEnvironmentVariables());
    }

    public TestOutcomeRequirementsTagProvider fromSourceDirectory(Path sourceDirectory) {
        this.sourceDirectory = sourceDirectory;
        return this;
    }

    public TestOutcomeRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
    }

    @Override
    public List<String> getActiveRequirementTypes() {
        HashMap requirementsDepth = new HashMap();
        this.getFlattenedRequirements().forEach(requirement -> {
            if (requirementsDepth.getOrDefault(requirement.getType(), 0) < requirement.getDepth()) {
                requirementsDepth.put(requirement.getType(), requirement.getDepth());
            }
        });
        return requirementsDepth.entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public List<Requirement> getRequirements() {
        return RequirementCache.getInstance().getRequirements(this::loadRequirements);
    }

    private Stream<TestOutcome> supportedOutcomesFrom(List<TestOutcome> outcomes) {
        return outcomes.stream().filter(outcome -> outcome.getTestSource() == null || SUPPORTED_TEST_SOURCES.contains(outcome.getTestSource()));
    }

    private List<Requirement> loadRequirements() {
        TestOutcomeLoader loader = new TestOutcomeLoader();
        File outputDirectory = ConfiguredEnvironment.getConfiguration().getOutputDirectory();
        File requirementsDirectory = this.sourceDirectory != null && this.sourceDirectory.toFile().exists() ? this.sourceDirectory.toFile() : outputDirectory;
        if (!requirementsDirectory.exists()) {
            return new ArrayList<Requirement>();
        }
        List<TestOutcome> outcomes = loader.loadFrom(requirementsDirectory);
        int maxRequirementsDepth = this.getMaxRequirementsDepthFrom(outcomes);
        Map<PathElements, Requirement> leafLevelRequirements = this.getLeafLevelRequirementsFrom(outcomes);
        Set<PathElements> leafPathElements = leafLevelRequirements.keySet();
        HashMap<PathElements, Requirement> requirementsByPath = new HashMap<PathElements, Requirement>();
        this.findPathElementsIn(outcomes).forEach(pathElements -> this.processPathElements((PathElements)pathElements, maxRequirementsDepth, leafPathElements, leafLevelRequirements, (Map<PathElements, Requirement>)requirementsByPath));
        Collection<Requirement> allRequirements = requirementsByPath.values();
        TestOutcomeRequirementsTagProvider.updateParentFieldsIn(requirementsByPath, allRequirements);
        TestOutcomeRequirementsTagProvider.populateChildren(requirementsByPath, allRequirements);
        RequirementCache.getInstance().indexRequirements(requirementsByPath);
        return allRequirements.stream().filter(requirement -> StringUtils.isEmpty((CharSequence)requirement.getParent())).collect(Collectors.toList());
    }

    private void processPathElements(PathElements pathElements, int maxRequirementsDepth, Set<PathElements> leafPathElements, Map<PathElements, Requirement> leafLevelRequirements, Map<PathElements, Requirement> requirementsByPath) {
        Requirement requirement = this.nonLeafRequirementFrom(pathElements, maxRequirementsDepth);
        this.addImmediateParentRequirement(pathElements, requirement, leafPathElements, leafLevelRequirements, requirementsByPath);
        this.addHigherLevelRequirements(pathElements, maxRequirementsDepth, leafPathElements, leafLevelRequirements, requirementsByPath);
    }

    private void addImmediateParentRequirement(PathElements pathElements, Requirement requirement, Set<PathElements> leafPathElements, Map<PathElements, Requirement> leafLevelRequirements, Map<PathElements, Requirement> requirementsByPath) {
        if (leafPathElements.contains(requirement.getPathElements())) {
            requirementsByPath.put(pathElements, leafLevelRequirements.get(requirement.getPathElements()));
        } else {
            requirementsByPath.put(pathElements, requirement);
        }
    }

    private void addHigherLevelRequirements(PathElements pathElements, int maxRequirementsDepth, Set<PathElements> leafPathElements, Map<PathElements, Requirement> leafLevelRequirements, Map<PathElements, Requirement> requirementsByPath) {
        for (PathElements parentPath = pathElements.getParent(); parentPath != null; parentPath = parentPath.getParent()) {
            if (parentPath.isEmpty() || requirementsByPath.containsKey(parentPath) || leafPathElements.contains(parentPath)) continue;
            Requirement nonLeafRequirement = this.nonLeafRequirementFrom(parentPath, maxRequirementsDepth);
            if (leafPathElements.contains(nonLeafRequirement.getPathElements())) {
                requirementsByPath.put(pathElements, leafLevelRequirements.get(nonLeafRequirement.getPathElements()));
                continue;
            }
            requirementsByPath.put(parentPath, nonLeafRequirement);
        }
    }

    private static void updateParentFieldsIn(Map<PathElements, Requirement> requirementsByPath, Collection<Requirement> allRequirements) {
        allRequirements.forEach(requirement -> {
            Requirement parentRequirement;
            PathElements parentPath = requirement.getPathElements().getParent();
            if (parentPath != null && !parentPath.isEmpty() && (parentRequirement = (Requirement)requirementsByPath.get(parentPath)) != null) {
                requirement.setParent(parentRequirement.getPath());
            }
        });
    }

    @NotNull
    private List<PathElements> findPathElementsIn(List<TestOutcome> outcomes) {
        return this.supportedOutcomesFrom(outcomes).map(outcome -> outcome.getUserStory().getPathElements()).distinct().map(this::relativePathFrom).filter(pathElements -> !pathElements.isEmpty()).collect(Collectors.toList());
    }

    @NotNull
    private Map<PathElements, Requirement> getLeafLevelRequirementsFrom(List<TestOutcome> outcomes) {
        Map<PathElements, Requirement> leafLevelRequirements = this.supportedOutcomesFrom(outcomes).map(TestOutcome::getUserStory).map(this::requirementFrom).distinct().collect(Collectors.toMap(Requirement::getPathElements, requirement -> requirement));
        return leafLevelRequirements;
    }

    private int getMaxRequirementsDepthFrom(List<TestOutcome> outcomes) {
        int maxRequirementsDepth = this.supportedOutcomesFrom(outcomes).filter(outcome -> !outcome.getUserStory().getParentPathElements().isEmpty()).mapToInt(outcome -> outcome.getUserStory().getParentPathElements().size()).max().orElse(0);
        return maxRequirementsDepth;
    }

    @Override
    public void addRequirementTagsTo(TestOutcome outcome) {
        if (outcome.getPath() == null) {
            return;
        }
        Map<String, Requirement> index = RequirementCache.getInstance().getRequirementsPathIndex();
        Requirement parentRequirement = index.get(outcome.getPath());
        if (parentRequirement != null) {
            outcome.addTags(this.requirementTagsFrom(parentRequirement, index));
        }
    }

    private static void populateChildren(Map<PathElements, Requirement> requirementsByPath, Collection<Requirement> allRequirements) {
        requirementsByPath.forEach((path, requirement) -> {
            List<Requirement> childRequirements = allRequirements.stream().filter(childRequirement -> childRequirement.hasParent((PathElements)path)).collect(Collectors.toList());
            requirement.setChildren(childRequirements);
        });
    }

    private List<TestTag> requirementTagsFrom(Requirement requirement, Map<String, Requirement> requirementsIndex) {
        ArrayList<TestTag> tags = new ArrayList<TestTag>();
        if (requirement == null) {
            return tags;
        }
        tags.add(requirement.asTag());
        while (requirement != null && requirement.getParent() != null && !requirement.getParent().isEmpty()) {
            if ((requirement = requirementsIndex.get(requirement.getParent())) == null) continue;
            tags.add(requirement.asTag());
        }
        return tags;
    }

    private Requirement nonLeafRequirementFrom(PathElements relativePath, int maxRequirementsDepth) {
        PathElement requirementLeaf = (PathElement)relativePath.get(relativePath.size() - 1);
        String path = relativePath.toString();
        String parentPath = relativePath.getParent().toString();
        String requirementName = requirementLeaf.getName();
        String requirementType = this.requirementsConfiguration.getRequirementType(relativePath.size() - 1, maxRequirementsDepth);
        return Requirement.named(requirementName).withId(StringUtils.isBlank((CharSequence)path) ? requirementLeaf.getName() : path).withType(requirementType).withNarrative("").withDisplayName(requirementLeaf.getDescription()).withPath(path).withParent(parentPath);
    }

    protected String humanReadableVersionOf(String name) {
        String underscoredName = Inflector.getInstance().underscore(name, new char[0]);
        return Inflector.getInstance().humanize(underscoredName, new String[0]);
    }

    private PathElements relativePathFrom(PathElements pathElements) {
        List<String> rootPackageElements = this.rootPackageElements();
        ArrayList<PathElement> relativePathElements = new ArrayList<PathElement>(pathElements);
        for (String rootPackageElement : rootPackageElements) {
            if (!((PathElement)relativePathElements.get(0)).getName().equals(rootPackageElement)) continue;
            relativePathElements.remove(0);
        }
        return PathElements.from(relativePathElements);
    }

    @NotNull
    private List<String> rootPackageElements() {
        String rootPackage = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables, "");
        return Splitter.on((String)".").omitEmptyStrings().splitToList((CharSequence)rootPackage);
    }

    private Requirement requirementFrom(Story userStory) {
        PathElement requirementLeaf = (PathElement)userStory.getPathElements().get(userStory.getPathElements().size() - 1);
        String parent = userStory.getPathElements().getParent() != null ? userStory.getPathElements().getParent().toString() : "";
        String requirementName = requirementLeaf.getName();
        return Requirement.named(requirementName).withId(userStory.getPathElements().toString()).withType(userStory.getType()).withNarrative(userStory.getNarrative()).withDisplayName(userStory.getDisplayName()).withParent(parent).withPath(userStory.getPath());
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() == null || testOutcome.getUserStory().getPath() == null) {
            return Optional.empty();
        }
        return this.getFlattenedRequirements().stream().filter(requirement -> requirement.matchesUserStory(testOutcome.getUserStory())).findFirst();
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(Requirement requirement) {
        return this.getFlattenedRequirements().stream().filter(parentRequirement -> requirement.hasParent(parentRequirement.getPath())).findFirst();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        boolean forceLoadFeatures = testTag.getType().equals("feature");
        Requirement matchingRequirement = RequirementCache.getInstance().getRequirementsByTag(testTag, this::findRequirementByTag, forceLoadFeatures);
        return Optional.ofNullable(matchingRequirement);
    }

    private Requirement findRequirementByTag(TestTag tag) {
        for (Requirement requirement : this.getFlattenedRequirements()) {
            if (!requirement.matchesTag(tag)) continue;
            return requirement;
        }
        return null;
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> result = new HashSet<TestTag>();
        Optional<Requirement> parentRequirement = this.getParentRequirementOf(testOutcome);
        if (parentRequirement.isPresent()) {
            result.add(parentRequirement.get().asTag());
            Optional<Requirement> parent = this.getParentRequirementOf(parentRequirement.get());
            while (parent.isPresent()) {
                result.add(parent.get().asTag());
                parent = this.getParentRequirementOf(parent.get());
            }
        }
        return result;
    }

    public List<Requirement> getFlattenedRequirements() {
        return this.getFlattenedRequirements(this.getRequirements());
    }

    private List<Requirement> flattenedRequirementsFrom(List<Requirement> requirements) {
        ArrayList<Requirement> flattenedRequirements = new ArrayList<Requirement>();
        for (Requirement requirement : requirements) {
            flattenedRequirements.add(requirement);
            if (requirement.getChildren() == null || requirement.getChildren().isEmpty()) continue;
            flattenedRequirements.addAll(this.flattenedRequirementsFrom(requirement.getChildren()));
        }
        return flattenedRequirements;
    }

    private List<Requirement> getFlattenedRequirements(List<Requirement> requirements) {
        if (RequirementCache.getInstance().getFlattenedRequirements().isEmpty()) {
            RequirementCache.getInstance().updateFlattenedRequirements(this.flattenedRequirementsFrom(requirements));
        }
        return RequirementCache.getInstance().getFlattenedRequirements();
    }
}

