/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain.stacktrace;

import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.thucydides.model.domain.failures.FailureAnalysis;
import net.thucydides.model.domain.stacktrace.FailureCause;
import net.thucydides.model.domain.stacktrace.StackTraceSanitizer;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.webdriver.WebdriverAssertionError;

public class RootCauseAnalyzer {
    private final Throwable thrownException;
    private final FailureAnalysis failureAnalysis;
    private final EnvironmentVariables environmentVariables;

    public RootCauseAnalyzer(Throwable thrownException) {
        this.thrownException = thrownException;
        this.environmentVariables = ConfiguredEnvironment.getEnvironmentVariables();
        this.failureAnalysis = new FailureAnalysis(this.environmentVariables);
    }

    public FailureCause getRootCause() {
        Throwable originalException = this.originalExceptionFrom(this.thrownException);
        StackTraceSanitizer stackTraceSanitizer = StackTraceSanitizer.forStackTrace(originalException.getStackTrace());
        return new FailureCause(originalException, stackTraceSanitizer.getSanitizedStackTrace());
    }

    private Throwable originalExceptionFrom(Throwable thrownException) {
        if (!(thrownException instanceof WebdriverAssertionError) && (thrownException instanceof SerenityManagedException || thrownException instanceof AssertionError)) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsError(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsCompromised(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsFailure(thrownException.getClass())) {
            return thrownException;
        }
        if (this.failureAnalysis.reportAsPending(thrownException.getClass())) {
            return thrownException;
        }
        return thrownException.getCause() != null ? thrownException.getCause() : thrownException;
    }

    public String getClassname() {
        return this.getRootCause().getErrorType();
    }

    public String getMessage() {
        if (this.thrownException.getMessage() != null) {
            return this.thrownException.getMessage();
        }
        if (this.getRootCause().getMessage() != null) {
            return this.getRootCause().getMessage().replace("java.lang.AssertionError", "");
        }
        return null;
    }
}

