/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.requirements.BaseRequirementsService;
import net.thucydides.model.requirements.ReleaseProvider;
import net.thucydides.model.requirements.RequirementAncestry;
import net.thucydides.model.requirements.RequirementsCollector;
import net.thucydides.model.requirements.RequirementsProvided;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.time.StopWatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregateRequirementsService
extends BaseRequirementsService
implements RequirementsService {
    private final List<RequirementsTagProvider> requirementsTagProviders;
    private static final Logger LOGGER = LoggerFactory.getLogger(AggregateRequirementsService.class);

    public AggregateRequirementsService(EnvironmentVariables environmentVariables, RequirementsTagProvider ... tagProviders) {
        super(environmentVariables);
        this.requirementsTagProviders = List.of(tagProviders);
    }

    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null || this.requirements.isEmpty()) {
            StopWatch stopWatch = StopWatch.createStarted();
            this.requirements = ((Stream)this.getRequirementsTagProviders().stream().parallel()).flatMap(RequirementsProvided::asStream).collect(RequirementsCollector.merging());
            stopWatch.split();
            LOGGER.debug("Requirements loaded in {}", (Object)stopWatch.formatSplitTime());
            RequirementAncestry.addParentsTo(this.requirements);
            this.indexRequirements();
            stopWatch.split();
            LOGGER.debug("Requirements loaded and indexed in {}", (Object)stopWatch.formatTime());
        }
        return this.requirements;
    }

    @Override
    public Optional<ReleaseProvider> getReleaseProvider() {
        List<RequirementsTagProvider> requirementsTagProviders = this.getRequirementsTagProviders();
        for (RequirementsTagProvider provider : requirementsTagProviders) {
            if (!(provider instanceof ReleaseProvider) || !((ReleaseProvider)((Object)provider)).isActive()) continue;
            return Optional.of((ReleaseProvider)((Object)provider));
        }
        return Optional.empty();
    }

    public List<RequirementsTagProvider> getRequirementsTagProviders() {
        return this.requirementsTagProviders;
    }

    @Override
    public void addRequirementTagsTo(TestOutcome outcome) {
        this.getRequirementsTagProviders().forEach(provider -> provider.addRequirementTagsTo(outcome));
    }
}

