/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import com.vladsch.flexmark.ext.resizable.image.ResizableImageExtension;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.ast.Document;
import com.vladsch.flexmark.util.ast.Node;
import com.vladsch.flexmark.util.data.DataHolder;
import com.vladsch.flexmark.util.data.MutableDataSet;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.serenitybdd.model.collect.NewList;
import net.serenitybdd.model.exceptions.SerenityManagedException;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.domain.PathElements;
import net.thucydides.model.domain.RequirementCache;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestTag;
import net.thucydides.model.environment.SystemEnvironmentVariables;
import net.thucydides.model.files.TheDirectoryStructure;
import net.thucydides.model.requirements.AbstractRequirementsTagProvider;
import net.thucydides.model.requirements.AllRequirements;
import net.thucydides.model.requirements.FeatureFilePath;
import net.thucydides.model.requirements.OverridableTagProvider;
import net.thucydides.model.requirements.RequirementAncestry;
import net.thucydides.model.requirements.RequirementsPath;
import net.thucydides.model.requirements.RequirementsTagProvider;
import net.thucydides.model.requirements.RootDirectory;
import net.thucydides.model.requirements.SpecFileFilters;
import net.thucydides.model.requirements.model.FeatureType;
import net.thucydides.model.requirements.model.NarrativeReader;
import net.thucydides.model.requirements.model.OverviewReader;
import net.thucydides.model.requirements.model.Requirement;
import net.thucydides.model.requirements.model.RequirementDefinition;
import net.thucydides.model.requirements.model.RequirementsConfiguration;
import net.thucydides.model.requirements.model.cucumber.CucumberParser;
import net.thucydides.model.requirements.model.cucumber.InvalidFeatureFileException;
import net.thucydides.model.util.EnvironmentVariables;
import net.thucydides.model.util.Inflector;
import net.thucydides.model.util.NameConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemRequirementsTagProvider
extends AbstractRequirementsTagProvider
implements RequirementsTagProvider,
OverridableTagProvider {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileSystemRequirementsTagProvider.class);
    private static final List<Requirement> NO_REQUIREMENTS = new ArrayList<Requirement>();
    private static final List<TestTag> NO_TEST_TAGS = new ArrayList<TestTag>();
    private static final String STORY_EXTENSION = "story";
    private static final String FEATURE_EXTENSION = "feature";
    private static final String DEFAULT_FEATURE_DIRECTORY = "src/test/resources/features";
    private final NarrativeReader narrativeReader;
    private final Set<String> directoryPaths;
    private final int level;
    private final RequirementsConfiguration requirementsConfiguration;
    private volatile List<Requirement> requirements;
    private final String topLevelDirectory;
    private boolean addParents = true;
    private static final DataHolder MARKDOWN_OPTIONS = new MutableDataSet().set(Parser.EXTENSIONS, Collections.singleton(ResizableImageExtension.create())).toImmutable();
    private final Parser parser = Parser.builder((DataHolder)MARKDOWN_OPTIONS).build();
    private final HtmlRenderer renderer = HtmlRenderer.builder((DataHolder)MARKDOWN_OPTIONS).build();
    private final Set<File> invalidFeatureFiles = new HashSet<File>();

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables) {
        this(environmentVariables, RootDirectory.definedIn(environmentVariables).featuresOrStoriesRootDirectory().orElse(FileSystemRequirementsTagProvider.defaultFeatureDirectory()).toString());
    }

    private static Path defaultFeatureDirectory() {
        return Paths.get(System.getProperty("user.dir"), new String[0]).resolve(DEFAULT_FEATURE_DIRECTORY);
    }

    public FileSystemRequirementsTagProvider(EnvironmentVariables environmentVariables, String rootDirectoryPath) {
        this(rootDirectoryPath, environmentVariables);
    }

    public FileSystemRequirementsTagProvider() {
        this(SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), level, SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    private static String filePathFormOf(String rootDirectory) {
        if (rootDirectory.contains(".")) {
            return rootDirectory.replace(".", "/");
        }
        return rootDirectory;
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.topLevelDirectory = rootDirectory;
        this.narrativeReader = NarrativeReader.forRootDirectory(environmentVariables, rootDirectory);
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.directoryPaths = FileSystemRequirementsTagProvider.rootDirectories(rootDirectory, environmentVariables);
        this.level = this.requirementsConfiguration.startLevelForADepthOf(this.maxDirectoryDepthIn(this.directoryPaths) + 1);
    }

    public FileSystemRequirementsTagProvider(String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        this(rootDirectory, rootDirectory, level, environmentVariables);
    }

    public FileSystemRequirementsTagProvider(String topLevelDirectory, String rootDirectory, int level, EnvironmentVariables environmentVariables) {
        super(environmentVariables, rootDirectory);
        this.topLevelDirectory = topLevelDirectory;
        this.narrativeReader = NarrativeReader.forRootDirectory(environmentVariables, rootDirectory);
        this.directoryPaths = FileSystemRequirementsTagProvider.rootDirectories(rootDirectory, environmentVariables);
        this.requirementsConfiguration = new RequirementsConfiguration(environmentVariables);
        this.level = level;
    }

    private static Set<String> rootDirectories(String rootDirectory, EnvironmentVariables environmentVariables) {
        return new RootDirectory(environmentVariables, rootDirectory).getRootDirectoryPaths();
    }

    public FileSystemRequirementsTagProvider(String rootDirectory) {
        this(FileSystemRequirementsTagProvider.filePathFormOf(rootDirectory), SystemEnvironmentVariables.currentEnvironmentVariables());
    }

    private RequirementsTagProvider withoutAddingParents() {
        this.addParents = false;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Requirement> getRequirements() {
        if (this.requirements == null) {
            FileSystemRequirementsTagProvider fileSystemRequirementsTagProvider = this;
            synchronized (fileSystemRequirementsTagProvider) {
                if (this.requirements == null) {
                    List<Requirement> loadedRequirements = this.getRootDirectoryPaths().stream().flatMap(this::capabilitiesAndStoriesIn).sorted().collect(Collectors.toList());
                    if (this.addParents) {
                        RequirementAncestry.addParentsTo(loadedRequirements);
                    }
                    this.requirements = loadedRequirements;
                    RequirementCache.getInstance().indexRequirements(this.indexByPath(this.requirements));
                }
            }
        }
        return this.requirements;
    }

    private Map<PathElements, Requirement> indexByPath(List<Requirement> requirements) {
        HashMap<PathElements, Requirement> index = new HashMap<PathElements, Requirement>();
        requirements.forEach(requirement -> index.put(requirement.getPathElements(), (Requirement)requirement));
        return index;
    }

    private Stream<Requirement> capabilitiesAndStoriesIn(String path) {
        File rootDirectory = new File(path);
        if (!rootDirectory.exists()) {
            return NO_REQUIREMENTS.stream();
        }
        return Stream.concat(this.loadCapabilitiesFrom(rootDirectory.listFiles(this.thatAreFeatureDirectories())), this.loadStoriesFrom(rootDirectory.listFiles(this.thatAreStories())));
    }

    private int maxDirectoryDepthIn(Set<String> directoryPaths) {
        return directoryPaths.stream().map(this::normalised).mapToInt(directoryPath -> TheDirectoryStructure.startingAt(new File((String)directoryPath)).maxDepth()).max().orElse(0);
    }

    public Set<String> getRootDirectoryPaths() {
        return new RootDirectory(this.environmentVariables, this.rootDirectory).getRootDirectoryPaths();
    }

    @Override
    public Set<TestTag> getTagsFor(TestOutcome testOutcome) {
        HashSet<TestTag> tags = new HashSet<TestTag>();
        if (testOutcome.getPath() != null) {
            Optional<TestTag> matchingRequirementTag;
            Optional<Requirement> matchingRequirement = this.requirementWithMatchingFeatureFile(testOutcome);
            matchingRequirement.ifPresent(requirement -> {
                tags.add(requirement.asTag());
                tags.addAll(this.parentRequirementsOf(requirement.asTag()));
            });
            List<String> storyPathElements = this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath())));
            tags.addAll(this.getMatchingCapabilities(this.getRequirements(), this.stripStorySuffixFrom(storyPathElements)));
            if (tags.isEmpty() && this.storyOrFeatureDescribedIn(storyPathElements).isPresent() && (matchingRequirementTag = this.getMatchingRequirementTagsFor(this.storyOrFeatureDescribedIn(storyPathElements).get())).isPresent()) {
                tags.add(matchingRequirementTag.get());
                tags.addAll(this.parentRequirementsOf(matchingRequirementTag.get()));
            }
        }
        return tags;
    }

    Optional<Requirement> requirementWithMatchingFeatureFile(TestOutcome testOutcome) {
        String candidatePath = testOutcome.getPath();
        String parentRequirementId = testOutcome.getParentId();
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getId() != null && requirement.getId().equals(parentRequirementId) || requirement.getFeatureFileName() != null && requirement.getFeatureFileName().equalsIgnoreCase(candidatePath) || requirement.getPath() != null && this.equivalentPaths(requirement.getPath(), candidatePath)).findFirst();
    }

    private Collection<TestTag> parentRequirementsOf(TestTag requirementTag) {
        ArrayList<TestTag> matchingTags = new ArrayList<TestTag>();
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(requirementTag);
        Optional<Requirement> parent = this.parentRequirementsOf(matchingRequirement.get());
        while (parent.isPresent()) {
            matchingTags.add(parent.get().asTag());
            parent = this.parentRequirementsOf(parent.get());
        }
        return matchingTags;
    }

    private Optional<Requirement> parentRequirementsOf(Requirement matchingRequirement) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getChildren().contains(matchingRequirement)).findFirst();
    }

    private List<String> stripStorySuffixFrom(List<String> pathElements) {
        if (!pathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(pathElements))) {
            return this.dropLastElement(pathElements);
        }
        return pathElements;
    }

    private List<String> dropLastElement(List<String> pathElements) {
        ArrayList<String> strippedPathElements = new ArrayList<String>(pathElements);
        strippedPathElements.remove(pathElements.size() - 1);
        return strippedPathElements;
    }

    private Optional<Requirement> getMatchingRequirementFor(TestTag storyOrFeatureTag) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.asTag().isAsOrMoreSpecificThan(storyOrFeatureTag)).findFirst();
    }

    private Optional<TestTag> getMatchingRequirementTagsFor(TestTag storyOrFeatureTag) {
        Optional<Requirement> matchingRequirement = this.getMatchingRequirementFor(storyOrFeatureTag);
        return matchingRequirement.map(Requirement::asTag);
    }

    private Optional<TestTag> storyOrFeatureDescribedIn(List<String> storyPathElements) {
        if (!storyPathElements.isEmpty() && this.isSupportedFileStoryExtension(this.last(storyPathElements))) {
            String storyName = NewList.reverse(storyPathElements).get(1);
            String storyParent = this.parentElement(storyPathElements);
            String qualifiedName = storyParent == null ? NameConverter.humanize(storyName) : NameConverter.humanize(storyParent).trim() + "/" + NameConverter.humanize(storyName);
            TestTag storyTag = TestTag.withName(qualifiedName).andType(this.last(storyPathElements));
            return Optional.of(storyTag);
        }
        return Optional.empty();
    }

    private String parentElement(List<String> storyPathElements) {
        return storyPathElements.size() > 2 ? NewList.reverse(storyPathElements).get(2) : null;
    }

    private String last(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(list.size() - 1);
    }

    @Override
    public Optional<Requirement> getParentRequirementOf(TestOutcome testOutcome) {
        return this.firstRequirementFoundIn(this.parentRequirementFromUserStory(testOutcome), this.parentRequirementFromPackagePath(testOutcome), this.requirementWithMatchingParentId(testOutcome), this.requirementWithMatchingPath(testOutcome), this.featureTagRequirementIn(testOutcome), this.mostSpecificTagRequirementFor(testOutcome));
    }

    private Optional<Requirement> featureTagRequirementIn(TestOutcome testOutcome) {
        List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
        return this.lastRequirementFrom(storyPathElements);
    }

    private Optional<Requirement> parentRequirementFromUserStory(TestOutcome testOutcome) {
        if (testOutcome.getUserStory() != null) {
            return this.getMatchingRequirementFor(testOutcome.getUserStory().asSingleParentTag());
        }
        return Optional.empty();
    }

    private Optional<Requirement> parentRequirementFromPackagePath(TestOutcome testOutcome) {
        if (testOutcome.getPath() != null) {
            List<String> storyPathElements = this.stripStorySuffixFrom(this.stripRootFrom(RequirementsPath.pathElements(this.stripRootPathFrom(testOutcome.getPath()))));
            return this.lastRequirementFrom(storyPathElements);
        }
        return Optional.empty();
    }

    private Optional<Requirement> mostSpecificTagRequirementFor(TestOutcome testOutcome) {
        Optional<Requirement> mostSpecificRequirement = Optional.empty();
        int currentSpecificity = -1;
        for (TestTag tag : testOutcome.getTags()) {
            int specificity;
            Optional<Requirement> matchingRequirement = this.getRequirementFor(tag);
            if (!matchingRequirement.isPresent() || currentSpecificity >= (specificity = this.requirementsConfiguration.getRequirementTypes().indexOf(matchingRequirement.get().getType()))) continue;
            currentSpecificity = specificity;
            mostSpecificRequirement = matchingRequirement;
        }
        return mostSpecificRequirement;
    }

    private Optional<Requirement> requirementWithMatchingPath(TestOutcome testOutcome) {
        Path testOutcomeRequirementsPath = RootDirectory.definedIn(this.environmentVariables).getRelativePathOf(testOutcome.getPath());
        Optional<Requirement> requirementWithMatchingPath = AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> this.requirementHasPathMatching((Requirement)requirement, testOutcomeRequirementsPath)).findFirst();
        Optional<Requirement> requirementWithAMatchingName = AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> this.requirementHasNameMatching((Requirement)requirement, testOutcomeRequirementsPath)).findFirst();
        if (requirementWithMatchingPath.isPresent()) {
            return requirementWithMatchingPath;
        }
        if (requirementWithAMatchingName.isPresent()) {
            return requirementWithAMatchingName;
        }
        if (testOutcome.getPath() == null) {
            return Optional.empty();
        }
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getPath() != null).filter(requirement -> this.equivalentPaths(requirement.getPath(), testOutcome.getPath())).findFirst();
    }

    private boolean requirementHasPathMatching(Requirement requirement, Path expectedPath) {
        return requirement.getPath() != null && expectedPath.equals(Paths.get(requirement.getPath(), new String[0]));
    }

    private boolean requirementHasNameMatching(Requirement requirement, Path expectedPath) {
        return requirement.getFeatureFileName() != null && expectedPath.equals(Paths.get(requirement.getFeatureFileName(), new String[0]));
    }

    private boolean equivalentPaths(String pathA, String pathB) {
        String normalisedPathA = this.removeFeatureOrStoryPrefixFrom(pathA.replaceAll("[/\\\\]", "/")).replaceAll("\\.", "/").replaceAll(" ", "_");
        String normalisedPathB = this.removeFeatureOrStoryPrefixFrom(pathB.replaceAll("[/\\\\]", "/")).replaceAll("\\.", "/").replaceAll(" ", "_");
        return normalisedPathA.equalsIgnoreCase(normalisedPathB);
    }

    private String removeFeatureOrStoryPrefixFrom(String path) {
        String stories = RootDirectory.definedIn(this.environmentVariables).storyDirectoryName();
        String features = RootDirectory.definedIn(this.environmentVariables).featureDirectoryName();
        if (path.startsWith(stories)) {
            path = path.substring(stories.length() + 1);
        }
        if (path.startsWith(features)) {
            path = path.substring(stories.length() + 1);
        }
        if (path.endsWith(".story")) {
            path = path.substring(0, path.length() - 6);
        }
        if (path.endsWith(".feature")) {
            path = path.substring(0, path.length() - 8);
        }
        return path;
    }

    private Optional<Requirement> requirementWithMatchingParentId(TestOutcome testOutcome) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.getId() != null && testOutcome.getParentId() != null && requirement.getId().equals(testOutcome.getParentId())).findFirst();
    }

    @Override
    public Optional<Requirement> getRequirementFor(TestTag testTag) {
        Requirement matchingRequirement = RequirementCache.getInstance().getRequirementsByTag(testTag, this::findRequirementByTag);
        return Optional.ofNullable(matchingRequirement);
    }

    public Requirement findRequirementByTag(TestTag testTag) {
        return AllRequirements.asStreamFrom(this.getRequirements()).filter(requirement -> requirement.asTag().equals(testTag)).findFirst().orElse(null);
    }

    private Optional<Requirement> lastRequirementFrom(List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.empty();
        }
        return this.lastRequirementMatchingPath(this.getRequirements(), storyPathElements);
    }

    private Optional<Requirement> lastRequirementMatchingPath(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return Optional.empty();
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (!matchingRequirement.isPresent()) {
            return Optional.empty();
        }
        if (this.tail(storyPathElements).isEmpty()) {
            return matchingRequirement;
        }
        List<Requirement> childRequrements = matchingRequirement.get().getChildren();
        return this.lastRequirementMatchingPath(childRequrements, this.tail(storyPathElements));
    }

    private List<TestTag> getMatchingCapabilities(List<Requirement> requirements, List<String> storyPathElements) {
        if (storyPathElements.isEmpty()) {
            return NO_TEST_TAGS;
        }
        Optional<Requirement> matchingRequirement = this.findMatchingRequirementIn(this.next(storyPathElements), requirements);
        if (matchingRequirement.isPresent()) {
            TestTag thisTag = matchingRequirement.get().asTag();
            List<TestTag> remainingTags = this.getMatchingCapabilities(matchingRequirement.get().getChildren(), this.tail(storyPathElements));
            return this.concat(thisTag, remainingTags);
        }
        return NO_TEST_TAGS;
    }

    private List<String> stripRootFrom(List<String> storyPathElements) {
        return RequirementsPath.stripRootFromPath(this.rootDirectory, storyPathElements);
    }

    private String stripRootPathFrom(String testOutcomePath) {
        if (testOutcomePath == null) {
            return "";
        }
        String rootPath = ThucydidesSystemProperty.SERENITY_TEST_ROOT.from(this.environmentVariables);
        if (StringUtils.isNotEmpty((CharSequence)rootPath) && testOutcomePath.startsWith(rootPath) && !testOutcomePath.equals(rootPath)) {
            return testOutcomePath.substring(rootPath.length() + 1);
        }
        return testOutcomePath;
    }

    private List<TestTag> concat(TestTag thisTag, List<TestTag> remainingTags) {
        ArrayList<TestTag> totalTags = new ArrayList<TestTag>();
        totalTags.add(thisTag);
        totalTags.addAll(remainingTags);
        return totalTags;
    }

    private <T> T next(List<T> elements) {
        return elements.get(0);
    }

    private <T> List<T> tail(List<T> elements) {
        return elements.subList(1, elements.size());
    }

    private Optional<Requirement> findMatchingRequirementIn(String storyPathElement, List<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            String normalizedStoryPathElement = Inflector.getInstance().humanize(Inflector.getInstance().underscore(storyPathElement, new char[0]), new String[0]);
            if (!requirement.getName().equals(normalizedStoryPathElement) && !storyPathElement.equalsIgnoreCase(FilenameUtils.removeExtension((String)requirement.getFeatureFileName())) && !storyPathElement.equalsIgnoreCase(requirement.getName())) continue;
            return Optional.of(requirement);
        }
        return Optional.empty();
    }

    private Stream<Requirement> loadCapabilitiesFrom(File[] requirementDirectories) {
        return Arrays.stream(requirementDirectories).map(this::readRequirementFrom);
    }

    private Stream<Requirement> loadStoriesFrom(File[] storyFiles) {
        return Arrays.stream(storyFiles).map(this::readRequirementsFromStoryOrFeatureFile).filter(Optional::isPresent).map(Optional::get);
    }

    public String renderMarkdownWithoutTags(String text) {
        if (text == null) {
            return "";
        }
        Document document = this.parser.parse(text);
        return Jsoup.parse((String)this.renderer.render((Node)document)).text();
    }

    public Requirement readRequirementFrom(File requirementDirectory) {
        Optional<RequirementDefinition> requirementNarrative = this.narrativeReader.loadFrom(requirementDirectory = this.normalised(requirementDirectory), Math.max(0, this.level));
        if (!requirementNarrative.isPresent()) {
            return this.requirementFromDirectoryName(requirementDirectory);
        }
        return this.requirementWithNarrative(requirementDirectory, requirementDirectory.getName(), requirementNarrative.get());
    }

    public Optional<Requirement> readRequirementsFromStoryOrFeatureFile(File storyFile) {
        if (this.invalidFeatureFiles.contains(storyFile = this.normalised(storyFile))) {
            return Optional.empty();
        }
        FeatureType type = this.featureTypeOf(storyFile);
        try {
            Requirement requirement;
            Optional<RequirementDefinition> narrative = type == FeatureType.STORY ? this.loadFromStoryFile(storyFile) : this.loadFromFeatureFile(storyFile);
            String storyPath = this.requirementsConfiguration.relativePathOfFeatureFile(storyFile);
            String storyFileName = this.storyNameFrom(storyFile);
            String displayName = this.storyDisplayNameFrom(narrative, type, storyFile);
            if (narrative.isPresent()) {
                requirement = this.leafRequirementWithNarrative(storyFileName, displayName, storyPath, narrative.get()).withType(type.toString());
                if (narrative.get().background().isPresent()) {
                    requirement = requirement.withBackground(narrative.get().background().get());
                }
                if (narrative.get().getScenarios().isEmpty()) {
                    requirement = requirement.withNoScenarios();
                }
            } else {
                requirement = this.storyNamed(storyFileName, displayName, storyPath).withType(type.toString());
            }
            return Optional.of(requirement.definedInFile(storyFile));
        }
        catch (InvalidFeatureFileException invalidFeatureFile) {
            this.invalidFeatureFiles.add(storyFile);
            return Optional.empty();
        }
    }

    private String storyNameFrom(File storyFile) {
        return storyFile.getName().substring(0, storyFile.getName().lastIndexOf("."));
    }

    private String storyDisplayNameFrom(Optional<RequirementDefinition> narrative, FeatureType type, File storyFile) {
        if (narrative.isPresent() && StringUtils.isNotBlank((CharSequence)narrative.get().getTitle().orElse(""))) {
            return narrative.get().getTitle().get();
        }
        if (this.isSnakeCase(storyFile.getName())) {
            return storyFile.getName().replace(type.getExtension(), "").replace("_", " ");
        }
        String storyNameWithoutExtension = storyFile.getName().replace(type.getExtension(), "");
        String snakeCaseStoryName = Inflector.inflection().underscore(storyNameWithoutExtension, new char[0]);
        return Inflector.inflection().of(snakeCaseStoryName).asATitle().toString();
    }

    private boolean isSnakeCase(String name) {
        return name.contains("_");
    }

    private Optional<RequirementDefinition> loadFromStoryFile(File storyFile) {
        return this.narrativeReader.loadFromStoryFile(storyFile);
    }

    private Optional<RequirementDefinition> loadFromFeatureFile(File storyFile) {
        String explicitLocale = this.readLocaleFromFeatureFile(storyFile);
        CucumberParser parser = explicitLocale != null ? new CucumberParser(explicitLocale, this.environmentVariables) : new CucumberParser(this.environmentVariables);
        return parser.loadFeatureDefinition(storyFile);
    }

    private String readLocaleFromFeatureFile(File storyFile) {
        try {
            List featureFileLines = FileUtils.readLines((File)storyFile, (Charset)Charset.defaultCharset());
            for (String line : featureFileLines) {
                if (!line.startsWith("#") || !line.contains("language:")) continue;
                return line.substring(line.indexOf("language:") + 10).trim();
            }
        }
        catch (IOException e) {
            LOGGER.warn("Could not read feature file - is this file empty or badly formatted? " + String.valueOf(storyFile), (Throwable)e);
        }
        return null;
    }

    private FeatureType featureTypeOf(File storyFile) {
        return storyFile.getName().endsWith(".story") ? FeatureType.STORY : FeatureType.FEATURE;
    }

    private Requirement requirementFromDirectoryName(File requirementDirectory) {
        requirementDirectory = this.normalised(requirementDirectory);
        LOGGER.debug("Loading requirements from directory: {} ({})", (Object)requirementDirectory, (Object)requirementDirectory.getAbsolutePath());
        String requirementType = this.getRequirementTypeOf(requirementDirectory);
        String requirementName = requirementDirectory.getName();
        String displayName = this.humanReadableVersionOf(requirementName);
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        String path = new FeatureFilePath(this.environmentVariables).relativePathFor(requirementDirectory.getPath());
        return Requirement.named(requirementName).withOptionalDisplayName(displayName).withId(path).withType(requirementType).withNarrative("").withPath(path).withParent(this.parentFrom(path)).withChildren(children);
    }

    private String getRequirementTypeOf(File requirementDirectory) {
        LOGGER.debug("Get requirements type for: {} ({})", (Object)requirementDirectory, (Object)requirementDirectory.getAbsolutePath());
        int depth = this.requirementDepthOf(this.topLevelDirectory, requirementDirectory);
        int maxDepth = TheDirectoryStructure.startingAt(this.directoryAt(this.topLevelDirectory)).maxDepth();
        return this.getDefaultType(depth, maxDepth);
    }

    private File directoryAt(String path) {
        try {
            if (this.getClass().getClassLoader().getResource(path) != null) {
                return new File(this.getClass().getClassLoader().getResource(path).toURI());
            }
            return new File(path);
        }
        catch (URISyntaxException invalidRootDirectory) {
            throw new SerenityManagedException(invalidRootDirectory);
        }
    }

    private int requirementDepthOf(String rootDirectory, File requirementDirectory) {
        String normalizedRootDirectory;
        if (rootDirectory.equals(requirementDirectory.getPath())) {
            return 0;
        }
        String normalizedRequirementsPath = requirementDirectory.getPath().replace("\\", "/");
        int startOfRelativePath = normalizedRequirementsPath.indexOf(normalizedRootDirectory = rootDirectory.replace("\\", "/")) + normalizedRootDirectory.length() + 1;
        if (startOfRelativePath < normalizedRequirementsPath.length()) {
            String relativePath = normalizedRequirementsPath.substring(startOfRelativePath);
            return relativePath.split("\\/|\\\\").length - 1;
        }
        return 0;
    }

    private String relativeDirectoryOf(String path) {
        String baseDirectory = this.requirementsConfiguration.getRootDirectory();
        if (path.contains(baseDirectory)) {
            int relativePathStartsAt = path.indexOf(baseDirectory) + baseDirectory.length() + 1;
            return relativePathStartsAt < path.length() ? path.substring(relativePathStartsAt) : "";
        }
        return path;
    }

    private Requirement storyNamed(String storyName, String displayName, String path) {
        String shortName = this.humanReadableVersionOf(storyName);
        String relativePath = new FeatureFilePath(this.environmentVariables).relativePathFor(path);
        return Requirement.named(shortName).withId(relativePath).withOptionalDisplayName(displayName).withType(STORY_EXTENSION).withNarrative(shortName).withParent(this.parentFrom(relativePath)).withPath(relativePath);
    }

    private Requirement leafRequirementWithNarrative(String requirementName, String displayName, String path, RequirementDefinition requirementNarrative) {
        String cardNumber = requirementNarrative.getCardNumber().orElse(null);
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        String relativePath = new FeatureFilePath(this.environmentVariables).relativePathFor(path);
        return Requirement.named(requirementName).withId(relativePath).withOptionalParent(this.parentFrom(relativePath)).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withPath(relativePath).withParent(this.parentFrom(relativePath)).withReleaseVersions(releaseVersions).withTags(requirementNarrative.getTags()).withScenarioTags(requirementNarrative.getScenarioTags());
    }

    private Requirement requirementWithNarrative(File requirementDirectory, String requirementName, RequirementDefinition requirementNarrative) {
        requirementDirectory = this.normalised(requirementDirectory);
        String displayName = this.getTitleFromNarrativeOrDirectoryName(requirementNarrative, requirementName);
        String cardNumber = requirementNarrative.getCardNumber().orElse(null);
        String type = requirementNarrative.getType();
        List<String> releaseVersions = requirementNarrative.getVersionNumbers();
        List<Requirement> children = this.readChildrenFrom(requirementDirectory);
        String path = new FeatureFilePath(this.environmentVariables).relativePathFor(requirementDirectory.getPath());
        return Requirement.named(requirementName).withId(path).withOptionalParent(this.parentFrom(path)).withOptionalDisplayName(displayName).withOptionalCardNumber(cardNumber).withType(type).withNarrative(requirementNarrative.getText()).withReleaseVersions(releaseVersions).withPath(path).withParent(this.parentFrom(path)).withChildren(children);
    }

    private String parentFrom(String path) {
        return path.contains("/") ? path.substring(0, path.lastIndexOf("/")) : "";
    }

    private List<Requirement> readChildrenFrom(File requirementDirectory) {
        String childDirectory = this.rootDirectory + "/" + (requirementDirectory = this.normalised(requirementDirectory)).getName();
        if (this.childrenExistFor(childDirectory)) {
            RequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(this.rootDirectory, childDirectory, this.level + 1, this.environmentVariables).withoutAddingParents();
            return childReader.getRequirements();
        }
        if (this.childrenExistFor(requirementDirectory.getPath())) {
            RequirementsTagProvider childReader = new FileSystemRequirementsTagProvider(this.rootDirectory, requirementDirectory.getPath(), this.level + 1, this.environmentVariables).withoutAddingParents();
            return childReader.getRequirements();
        }
        return NO_REQUIREMENTS;
    }

    private boolean childrenExistFor(String path) {
        if (this.hasSubdirectories(path)) {
            return true;
        }
        if (this.hasFeatureStoryOrJavaScriptSpecFiles(path)) {
            return true;
        }
        return this.classpathResourceExistsFor(path);
    }

    private boolean hasFeatureStoryOrJavaScriptSpecFiles(String path) {
        File requirementDirectory = new File(path);
        if (!requirementDirectory.isDirectory()) {
            return false;
        }
        boolean hasStoryFiles = requirementDirectory.list(SpecFileFilters.jbehaveStoryFiles()).length > 0;
        boolean hasFeatureFiles = requirementDirectory.list(SpecFileFilters.cucumberFeatureFiles()).length > 0;
        boolean hasJavaScriptSpecFiles = requirementDirectory.list(SpecFileFilters.javascriptSpecFiles()).length > 0;
        return hasStoryFiles || hasFeatureFiles || hasJavaScriptSpecFiles;
    }

    private boolean classpathResourceExistsFor(String path) {
        return this.getClass().getResource(this.resourcePathFor(path)) != null;
    }

    private String resourcePathFor(String path) {
        return path.startsWith("/") ? path : "/" + path;
    }

    private boolean hasSubdirectories(String path) {
        File pathDirectory = this.normalised(new File(path));
        if (!pathDirectory.exists()) {
            return false;
        }
        for (File subdirectory : pathDirectory.listFiles()) {
            if (!subdirectory.isDirectory()) continue;
            return true;
        }
        return false;
    }

    private String getTitleFromNarrativeOrDirectoryName(RequirementDefinition requirementNarrative, String nameIfNoNarrativePresent) {
        if (requirementNarrative.getTitle().isPresent() && StringUtils.isNotBlank((CharSequence)requirementNarrative.getTitle().get())) {
            return this.renderMarkdownWithoutTags(requirementNarrative.getTitle().get());
        }
        return nameIfNoNarrativePresent;
    }

    private FileFilter thatAreFeatureDirectories() {
        return file -> !file.getName().startsWith(".") && this.storyFeatureFilesOrJavaScriptSpecsExistIn(file);
    }

    private boolean storyFeatureFilesOrJavaScriptSpecsExistIn(File directory) {
        return TheDirectoryStructure.startingAt(this.normalised(directory)).containsFiles(this.thatAreStories(), SpecFileFilters.thatAreNarratives(), SpecFileFilters.thatAreJavascriptSpecFiles());
    }

    private FileFilter thatAreStories() {
        return file -> {
            String filename = file.getName().toLowerCase();
            if (filename.startsWith("given") || filename.startsWith("precondition")) {
                return false;
            }
            return file.getName().toLowerCase().endsWith(".story") || file.getName().toLowerCase().endsWith(".feature");
        };
    }

    private boolean isSupportedFileStoryExtension(String storyFileExtension) {
        return storyFileExtension.equalsIgnoreCase(FEATURE_EXTENSION) || storyFileExtension.equalsIgnoreCase(STORY_EXTENSION);
    }

    @Override
    public Optional<String> getOverview() {
        return OverviewReader.readOverviewFrom(this.directoryPaths.toArray(new String[0]));
    }

    private File normalised(File directory) {
        return new File(this.normalised(directory.getPath()));
    }

    private String normalised(String directory) {
        return directory.replace("\\", "/");
    }
}

