/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.logging;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.logging.ConsoleEvent;
import net.thucydides.model.logging.ConsoleHeadingStyle;
import net.thucydides.model.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;

public class ConsoleHeading {
    private static Map<ConsoleEvent, List<String>> HEADINGS = new HashMap<ConsoleEvent, List<String>>();
    private final ConsoleHeadingStyle headingStyle;

    static String titleWithBorder(ConsoleEvent consoleEvent) {
        return "- " + consoleEvent.getTitle().toUpperCase();
    }

    public ConsoleHeading(EnvironmentVariables environmentVariables) {
        this.headingStyle = ConsoleHeadingStyle.definedIn(environmentVariables);
    }

    public String bannerFor(ConsoleEvent consoleEvent, String description) {
        String heading = this.headingFor(consoleEvent);
        String eventPrefix = this.eventPrefix(consoleEvent.getTitle());
        return heading + eventPrefix + description + this.underline(heading);
    }

    private String headingFor(ConsoleEvent consoleEvent) {
        return HEADINGS.get((Object)consoleEvent).get(this.headingStyle.getLevel());
    }

    private String eventPrefix(String prefix) {
        if (this.headingStyle.equals((Object)ConsoleHeadingStyle.NONE)) {
            return prefix + ": ";
        }
        return "\n";
    }

    private String underline(String banner) {
        StringBuilder underline = new StringBuilder();
        int endOfLine = banner.indexOf(10, 1);
        if (endOfLine >= 0) {
            underline.append(StringUtils.repeat((char)'-', (int)endOfLine));
        } else {
            underline.append(StringUtils.repeat((char)'-', (int)banner.length()));
        }
        return !underline.toString().isEmpty() ? "\n" + underline.toString() : "";
    }

    static {
        HEADINGS.put(ConsoleEvent.TEST_STARTED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_STARTED), "\n  _____   ___   ___   _____     ___   _____     _     ___   _____   ___   ___  \n |_   _| | __| / __| |_   _|   / __| |_   _|   /_\\   | _ \\ |_   _| | __| |   \\ \n   | |   | _|  \\__ \\   | |     \\__ \\   | |    / _ \\  |   /   | |   | _|  | |) |\n   |_|   |___| |___/   |_|     |___/   |_|   /_/ \\_\\ |_|_\\   |_|   |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_PASSED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_PASSED), "\n  _____   ___   ___   _____     ___     _     ___   ___   ___   ___  \n |_   _| | __| / __| |_   _|   | _ \\   /_\\   / __| / __| | __| |   \\ \n   | |   | _|  \\__ \\   | |     |  _/  / _ \\  \\__ \\ \\__ \\ | _|  | |) |\n   |_|   |___| |___/   |_|     |_|   /_/ \\_\\ |___/ |___/ |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_FAILED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_FAILED), "\n  _____   ___   ___   _____     ___     _     ___   _      ___   ___  \n |_   _| | __| / __| |_   _|   | __|   /_\\   |_ _| | |    | __| |   \\ \n   | |   | _|  \\__ \\   | |     | _|   / _ \\   | |  | |__  | _|  | |) |\n   |_|   |___| |___/   |_|     |_|   /_/ \\_\\ |___| |____| |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_ERROR, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_ERROR), "\n  _____   ___   ___   _____     ___   ___   ___    ___    ___ \n |_   _| | __| / __| |_   _|   | __| | _ \\ | _ \\  / _ \\  | _ \\\n   | |   | _|  \\__ \\   | |     | _|  |   / |   / | (_) | |   /\n   |_|   |___| |___/   |_|     |___| |_|_\\ |_|_\\  \\___/  |_|_\\\n"));
        HEADINGS.put(ConsoleEvent.TEST_COMPROMISED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_COMPROMISED), "\n  _____   ___   ___   _____ \n |_   _| | __| / __| |_   _|\n   | |   | _|  \\__ \\   | |  \n   |_|   |___| |___/   |_|  \n   ___    ___    __  __   ___   ___    ___    __  __   ___   ___   ___   ___  \n  / __|  / _ \\  |  \\/  | | _ \\ | _ \\  / _ \\  |  \\/  | |_ _| / __| | __| |   \\ \n | (__  | (_) | | |\\/| | |  _/ |   / | (_) | | |\\/| |  | |  \\__ \\ | _|  | |) |\n  \\___|  \\___/  |_|  |_| |_|   |_|_\\  \\___/  |_|  |_| |___| |___/ |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_SKIPPED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_COMPROMISED), "\n  _____   ___   ___   _____     ___   _  __  ___   ___   ___   ___   ___  \n |_   _| | __| / __| |_   _|   / __| | |/ / |_ _| | _ \\ | _ \\ | __| |   \\ \n   | |   | _|  \\__ \\   | |     \\__ \\ | ' <   | |  |  _/ |  _/ | _|  | |) |\n   |_|   |___| |___/   |_|     |___/ |_|\\_\\ |___| |_|   |_|   |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_ABORTED, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_COMPROMISED), "\n  _____   ___   ___   _____     ___   _  __  ___   ___   ___   ___   ___  \n |_   _| | __| / __| |_   _|   / __| | |/ / |_ _| | _ \\ | _ \\ | __| |   \\ \n   | |   | _|  \\__ \\   | |     \\__ \\ | ' <   | |  |  _/ |  _/ | _|  | |) |\n   |_|   |___| |___/   |_|     |___/ |_|\\_\\ |___| |_|   |_|   |___| |___/ \n"));
        HEADINGS.put(ConsoleEvent.TEST_PENDING, NewList.of("", ConsoleHeading.titleWithBorder(ConsoleEvent.TEST_PENDING), "\n  _____   ___   ___   _____     ___   ___   _  _   ___    ___   _  _    ___ \n |_   _| | __| / __| |_   _|   | _ \\ | __| | \\| | |   \\  |_ _| | \\| |  / __|\n   | |   | _|  \\__ \\   | |     |  _/ | _|  | .` | | |) |  | |  | .` | | (_ |\n   |_|   |___| |___/   |_|     |_|   |___| |_|\\_| |___/  |___| |_|\\_|  \\___|\n"));
    }
}

