/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import net.thucydides.model.matchers.BeanFieldMatcher;
import net.thucydides.model.matchers.InstantiatedBeanMatcher;
import net.thucydides.model.matchers.dates.BeanFields;
import org.hamcrest.Matcher;

public class BeanPropertyMatcher
implements BeanFieldMatcher {
    private final String fieldName;
    private final Matcher<? extends Object> matcher;

    public BeanPropertyMatcher(String fieldName, Matcher<? extends Object> matcher) {
        this.fieldName = fieldName;
        this.matcher = matcher;
    }

    @Override
    public boolean matches(Object bean) {
        return this.matcher.matches(BeanFields.fieldValueIn(bean).forField(this.fieldName));
    }

    @Override
    public <T> Matcher<T> getMatcher() {
        return new InstantiatedBeanMatcher(this);
    }

    public String toString() {
        String matcherDescription = this.matcher.toString();
        String htmlFriendlyMatcherDescription = matcherDescription.replaceAll("\"", "'");
        return this.fieldName + " " + htmlFriendlyMatcherDescription;
    }
}

