/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import java.util.List;
import net.serenitybdd.model.di.ModelInfrastructure;
import net.serenitybdd.model.environment.ConfiguredEnvironment;
import net.thucydides.model.domain.ReportType;
import net.thucydides.model.reports.html.ReportNameProvider;
import net.thucydides.model.requirements.Requirements;
import net.thucydides.model.requirements.RequirementsService;
import net.thucydides.model.requirements.reports.MultipleSourceRequirmentsOutcomeFactory;
import net.thucydides.model.requirements.reports.RequirementsOutcomeFactory;

public class DefaultRequirements
implements Requirements {
    private final RequirementsService requirementsService;
    private final RequirementsOutcomeFactory requirmentsOutcomeFactory;

    public DefaultRequirements(String testRootPackage) {
        if (testRootPackage != null) {
            ConfiguredEnvironment.getEnvironmentVariables().setProperty("serenity.test.root", testRootPackage);
        }
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()));
    }

    public DefaultRequirements() {
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.getRequirementsService()));
    }

    public DefaultRequirements(ReportNameProvider reportNameProvider) {
        this.requirementsService = ModelInfrastructure.getRequirementsService();
        this.requirmentsOutcomeFactory = new MultipleSourceRequirmentsOutcomeFactory(ModelInfrastructure.getRequirementsProviderService().getRequirementsProviders(), ModelInfrastructure.getIssueTracking(), reportNameProvider);
    }

    @Override
    public RequirementsService getRequirementsService() {
        return this.requirementsService;
    }

    @Override
    public RequirementsOutcomeFactory getRequirementsOutcomeFactory() {
        return this.requirmentsOutcomeFactory;
    }

    @Override
    public List<String> getTypes() {
        return this.requirementsService.getRequirementTypes();
    }
}

