/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.matchers;

import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.domain.TestOutcome;
import net.thucydides.model.domain.TestResult;
import net.thucydides.model.domain.TestStep;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class TestOutcomeResultsMatcher
extends TypeSafeMatcher<TestOutcome> {
    private final List<TestResult> expectedTestResults;

    public TestOutcomeResultsMatcher(TestResult ... expectedTestResults) {
        this.expectedTestResults = Arrays.asList(expectedTestResults);
    }

    public boolean matchesSafely(TestOutcome testOutcome) {
        List<TestStep> allSteps = testOutcome.getFlattenedTestSteps();
        List allTestResults = allSteps.stream().map(step -> step.getResult()).collect(Collectors.toList());
        return allTestResults.equals(this.expectedTestResults);
    }

    public void describeTo(Description description) {
        description.appendText("a test outcome with results " + Arrays.toString(this.expectedTestResults.toArray()));
    }
}

