/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements.classpath;

import java.util.Collection;
import net.thucydides.model.requirements.model.Requirement;

public class ChildElementAdder {
    private final Requirement parent;
    private final Requirement child;

    public ChildElementAdder(Requirement parent, Requirement child) {
        this.parent = parent;
        this.child = child;
    }

    public static ChildElementAdderBuilder addChild(Requirement requirement) {
        return new ChildElementAdderBuilder(requirement);
    }

    public void in(Collection<Requirement> requirements) {
        Requirement ancestor = this.parent;
        Requirement immediateDescendant = this.child;
        while (ancestor != null) {
            Requirement updatedAncestor = ancestor.withChild(immediateDescendant);
            this.replaceIn(requirements, ancestor, updatedAncestor);
            immediateDescendant = updatedAncestor;
            ancestor = this.requirementCalled(ancestor.getParent(), requirements);
        }
    }

    private Requirement requirementCalled(String requirementName, Collection<Requirement> requirements) {
        for (Requirement requirement : requirements) {
            if (!requirement.getName().equals(requirementName)) continue;
            return requirement;
        }
        return null;
    }

    private void replaceIn(Collection<Requirement> requirements, Requirement oldParent, Requirement updatedParent) {
        requirements.remove(oldParent);
        requirements.add(updatedParent);
    }

    public static class ChildElementAdderBuilder {
        private Requirement child;

        public ChildElementAdderBuilder(Requirement child) {
            this.child = child;
        }

        public ChildElementAdder toParent(Requirement parent) {
            return new ChildElementAdder(parent, this.child);
        }
    }
}

