/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.requirements;

import com.google.common.base.Splitter;
import java.util.List;
import net.serenitybdd.model.collect.NewList;
import net.thucydides.model.ThucydidesSystemProperty;
import net.thucydides.model.requirements.model.RequirementsConfiguration;
import net.thucydides.model.util.EnvironmentVariables;

public class ExcludedUnrelatedRequirementTypes {
    private static final String DEFAULT_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE = "theme,epic,capability,feature";
    private static final List<String> EXCLUDE_NONE = NewList.of("none");
    private final List<String> excludedTypes;
    private final RequirementsConfiguration requirementsConfiguration;

    public ExcludedUnrelatedRequirementTypes(List<String> excludedTypes, RequirementsConfiguration requirementsConfiguration) {
        this.excludedTypes = excludedTypes;
        this.requirementsConfiguration = requirementsConfiguration;
    }

    public static ExcludedUnrelatedRequirementTypes definedIn(EnvironmentVariables environmentVariables) {
        String unrleatedRequirementTypes = ThucydidesSystemProperty.SERENITY_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE.from(environmentVariables, DEFAULT_EXCLUDE_UNRELATED_REQUIREMENTS_OF_TYPE);
        return new ExcludedUnrelatedRequirementTypes(Splitter.on((String)",").trimResults().splitToList((CharSequence)unrleatedRequirementTypes), new RequirementsConfiguration(environmentVariables));
    }

    public boolean excludeUntestedRequirementOfType(String type) {
        if (this.excludedTypes == EXCLUDE_NONE) {
            return false;
        }
        return this.excludedTypes.contains(type);
    }

    public boolean excludeUntestedChildrenOfRequirementOfType(String type) {
        if (this.excludedTypes == EXCLUDE_NONE) {
            return false;
        }
        int requirementLevel = this.requirementsConfiguration.getRequirementTypes().indexOf(type.toLowerCase());
        String childRequirementType = this.requirementsConfiguration.getRequirementType(requirementLevel + 1);
        return this.excludedTypes.contains(childRequirementType);
    }
}

