/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.model.domain;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.thucydides.model.domain.PathElement;

public class PathElements
extends ArrayList<PathElement> {
    public static PathElements from(List<PathElement> elements) {
        PathElements pathElements = new PathElements();
        pathElements.addAll(elements);
        return pathElements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathElements)) {
            return false;
        }
        PathElements that = (PathElements)o;
        return this.toString().equals(that.toString());
    }

    @Override
    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public String toString() {
        return this.stream().map(PathElement::getName).collect(Collectors.joining("/"));
    }

    public PathElements copy() {
        return PathElements.from(this);
    }

    public PathElements getParent() {
        if (this.isEmpty()) {
            return null;
        }
        return PathElements.from(this.subList(0, this.size() - 1));
    }

    public String asPath() {
        return this.stream().map(PathElement::getName).collect(Collectors.joining("/"));
    }

    public PathElements stripFirstElements(List<String> rootElements) {
        if (this.size() < rootElements.size()) {
            return this;
        }
        for (int index = 0; index < rootElements.size(); ++index) {
            if (((PathElement)this.get(index)).getName().equals(rootElements.get(index))) continue;
            return this;
        }
        return PathElements.from(this.subList(rootElements.size(), this.size()));
    }

    public String getDisplayName() {
        if (this.isEmpty()) {
            return "";
        }
        return ((PathElement)this.get(this.size() - 1)).getDescription();
    }
}

