/*
 * Decompiled with CFR 0.152.
 */
package net.serenitybdd.model.time;

import java.text.DecimalFormat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Stopwatch {
    private static final Logger LOGGER = LoggerFactory.getLogger(Stopwatch.class);
    long startTimeInMillis = 0L;

    public static Stopwatch started() {
        Stopwatch stopwatch = new Stopwatch();
        stopwatch.start();
        return stopwatch;
    }

    public void start() {
        this.startTimeInMillis = System.currentTimeMillis();
    }

    public long stop() {
        this.validateStarted();
        long result = System.currentTimeMillis() - this.startTimeInMillis;
        this.startTimeInMillis = 0L;
        return result;
    }

    private void validateStarted() {
        if (this.startTimeInMillis == 0L) {
            throw new IllegalStateException("stopwatch is already stopped");
        }
    }

    public String lapTimeFormatted() {
        this.validateStarted();
        return this.lapTimeFormatted(System.currentTimeMillis() - this.startTimeInMillis);
    }

    public String executionTimeFormatted() {
        return this.lapTimeFormatted(this.stop());
    }

    public String lapTimeFormatted(Long executionTimeInMilliseconds) {
        return executionTimeInMilliseconds < 1000L ? executionTimeInMilliseconds + " ms" : (executionTimeInMilliseconds < 60000L ? new DecimalFormat("#,###.#").format((double)executionTimeInMilliseconds.longValue() / 1000.0) + " secs" : new DecimalFormat("#,###").format(executionTimeInMilliseconds / 60000L) + " mins and " + new DecimalFormat("##.#").format((double)(executionTimeInMilliseconds % 60000L) / 1000.0) + " secs");
    }

    public long lapTime() {
        this.validateStarted();
        return System.currentTimeMillis() - this.startTimeInMillis;
    }

    public long stop(String message) {
        long result = this.stop();
        LOGGER.debug("{} in {}", (Object)message, (Object)this.lapTimeFormatted(result));
        return result;
    }
}

