/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.github.rjeschke.txtmark.Configuration;
import com.google.common.base.Splitter;
import com.google.inject.Inject;
import com.google.inject.Key;
import com.vladsch.flexmark.ast.Document;
import com.vladsch.flexmark.ast.Node;
import com.vladsch.flexmark.html.HtmlRenderer;
import com.vladsch.flexmark.parser.Parser;
import com.vladsch.flexmark.util.options.DataHolder;
import com.vladsch.flexmark.util.options.MutableDataSet;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.html.ExampleTable;
import net.thucydides.core.reports.html.MarkdownRendering;
import net.thucydides.core.reports.html.ResultIconFormatter;
import net.thucydides.core.reports.html.ResultRankingFormatter;
import net.thucydides.core.reports.renderer.Asciidoc;
import net.thucydides.core.reports.renderer.MarkupRenderer;
import net.thucydides.core.util.EnvironmentVariables;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.translate.AggregateTranslator;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.EntityArrays;
import org.apache.commons.lang3.text.translate.LookupTranslator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Formatter {
    private static final String ELIPSE = "&hellip;";
    private static final String ASCIIDOC = "asciidoc";
    private static final String MARKDOWN = "markdown";
    private static final String TEXT = "";
    private static final String STANDARD_NEW_LINE = "\n";
    private static final String NEWLINE_CHAR = "\u2424";
    private static final String NEWLINE = "\u0085";
    private static final String LINE_SEPARATOR = "\u2028";
    private static final String PARAGRAPH_SEPARATOR = "\u2029";
    private static final Logger LOGGER = LoggerFactory.getLogger(Formatter.class);
    public static final String FOUR_SPACES = "&nbsp; &nbsp; &nbsp; &nbsp;";
    public static final String TAB = "\\t";
    public static final String NEW_LINE_ON_ANY_OS = "\\r?\\n";
    public static final String UTF_8_NEW_LINE = "\u2424";
    public static String[][] UNICODE_CHARS_ESCAPE = new String[][]{{"\\u", "&#92;"}};
    private final EnvironmentVariables environmentVariables;
    private final MarkupRenderer asciidocRenderer;
    Configuration markdownEncodingConfiguration;
    Parser parser;
    HtmlRenderer renderer;
    private static final CharSequenceTranslator ESCAPE_SPECIAL_CHARS = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.ISO8859_1_ESCAPE()), new LookupTranslator((CharSequence[][])EntityArrays.HTML40_EXTENDED_ESCAPE())});
    private final CharSequenceTranslator BASIC_XML = new AggregateTranslator(new CharSequenceTranslator[]{new LookupTranslator((CharSequence[][])EntityArrays.BASIC_ESCAPE()), new LookupTranslator((CharSequence[][])UNICODE_CHARS_ESCAPE)});

    @Inject
    public Formatter(EnvironmentVariables environmentVariables) {
        this.environmentVariables = environmentVariables;
        this.asciidocRenderer = (MarkupRenderer)Injectors.getInjector().getInstance(Key.get(MarkupRenderer.class, Asciidoc.class));
        String encoding = ThucydidesSystemProperty.REPORT_CHARSET.from(environmentVariables, "UTF-8");
        this.markdownEncodingConfiguration = Configuration.builder().setEncoding(encoding).build();
        MutableDataSet options = new MutableDataSet();
        this.parser = Parser.builder((DataHolder)options).build();
        this.renderer = HtmlRenderer.builder((DataHolder)options).build();
    }

    public Formatter() {
        this((EnvironmentVariables)Injectors.getInjector().getProvider(EnvironmentVariables.class).get());
    }

    public String renderAsciidoc(String text) {
        return this.stripNewLines(this.asciidocRenderer.render(text));
    }

    public String renderMarkdown(String text) {
        if (text == null) {
            return TEXT;
        }
        Document document = this.parser.parse(text);
        String html = this.renderer.render((Node)document);
        return this.stripSurroundingParagraphTagsFrom(html);
    }

    private String stripSurroundingParagraphTagsFrom(String text) {
        if (this.startsWithParagraphTag(text) && this.endWithParagraphTag(text)) {
            text = StringUtils.trim((String)text).substring(3);
            text = text.substring(0, text.length() - 4);
        }
        return text;
    }

    private boolean startsWithParagraphTag(String text) {
        return StringUtils.trim((String)text.toLowerCase()).startsWith("<p>");
    }

    private boolean endWithParagraphTag(String text) {
        return StringUtils.trim((String)text.toLowerCase()).endsWith("</p>");
    }

    private String stripNewLines(String render) {
        return render != null ? render.replaceAll(STANDARD_NEW_LINE, TEXT) : TEXT;
    }

    public String renderText(String text) {
        if (StringUtils.isEmpty((CharSequence)text)) {
            return TEXT;
        }
        return Formatter.concatLines(this.BASIC_XML.translate((CharSequence)text), "<br>").replaceAll(TAB, FOUR_SPACES);
    }

    public String renderHeaders(String text) {
        if (text == null) {
            return TEXT;
        }
        return Formatter.concatLines(this.BASIC_XML.translate((CharSequence)Formatter.stringFormOf(text)), "<br>").replaceAll(TAB, TEXT);
    }

    public String renderDescription(String text) {
        String format = this.environmentVariables.getProperty((Enum)ThucydidesSystemProperty.NARRATIVE_FORMAT, TEXT);
        if (this.isRenderedHtml(text)) {
            return text;
        }
        if (format.equalsIgnoreCase(ASCIIDOC)) {
            return this.renderAsciidoc(text);
        }
        if (format.equalsIgnoreCase(MARKDOWN) || MarkdownRendering.configuredIn((EnvironmentVariables)this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.narrative)) {
            return this.renderMarkdown(text);
        }
        return Formatter.addLineBreaks(text);
    }

    private boolean isRenderedHtml(String text) {
        return text != null && text.startsWith("<");
    }

    public static String addLineBreaks(String text) {
        return text != null ? Formatter.concatLines(text.trim(), "<br>") : TEXT;
    }

    public String convertAnyTables(String text) {
        if (this.shouldFormatEmbeddedTables() && this.containsEmbeddedTable(text)) {
            text = this.convertNonStandardNLChars(text);
            text = ExampleTable.stripBracketsFromOuterPipes(text);
            text = this.withTablesReplaced(text);
        }
        return text;
    }

    private String withTablesReplaced(String text) {
        List<String> unformattedTables = this.getEmbeddedTablesIn(text);
        for (String unformattedTable : unformattedTables) {
            ExampleTable table = new ExampleTable(unformattedTable);
            text = text.replace(unformattedTable, table.inHtmlFormat());
        }
        text = text.replaceAll(this.newLineUsedIn(text), "<br>");
        return text;
    }

    private String convertNonStandardNLChars(String text) {
        text = StringUtils.replace((String)text, (String)"\u2424", (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)NEWLINE, (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)LINE_SEPARATOR, (String)STANDARD_NEW_LINE);
        text = StringUtils.replace((String)text, (String)PARAGRAPH_SEPARATOR, (String)STANDARD_NEW_LINE);
        return text;
    }

    private boolean shouldFormatEmbeddedTables() {
        return ThucydidesSystemProperty.IGNORE_EMBEDDED_TABLES.booleanFrom(this.environmentVariables) == false;
    }

    private boolean containsEmbeddedTable(String text) {
        return this.positionOfFirstPipeIn(text) >= 0 && this.positionOfLastPipeIn(text) >= 0;
    }

    private int positionOfLastPipeIn(String text) {
        return text.indexOf("|", this.positionOfFirstPipeIn(text) + 1);
    }

    private int positionOfFirstPipeIn(String text) {
        return text.indexOf("|");
    }

    private List<String> getEmbeddedTablesIn(String text) {
        ArrayList<String> embeddedTables = new ArrayList<String>();
        StringBuffer tableText = new StringBuffer();
        try (BufferedReader reader = new BufferedReader(new StringReader(text));){
            String line;
            boolean inTable = false;
            String newLine = this.newLineUsedIn(text);
            while ((line = reader.readLine()) != null) {
                if (!inTable && line.contains("|")) {
                    inTable = true;
                } else if (inTable && !line.contains("|") && !this.isBlank(line)) {
                    embeddedTables.add(tableText.toString().trim());
                    tableText = new StringBuffer();
                    inTable = false;
                }
                if (!inTable) continue;
                tableText.append(line).append(newLine);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Could not process embedded table", e);
        }
        if (!tableText.toString().isEmpty()) {
            embeddedTables.add(tableText.toString().trim());
        }
        return embeddedTables;
    }

    private boolean isBlank(String line) {
        return StringUtils.isBlank((CharSequence)line.trim());
    }

    private String newLineUsedIn(String text) {
        if (text.contains("\r\n")) {
            return "\r\n";
        }
        if (text.contains(STANDARD_NEW_LINE)) {
            return STANDARD_NEW_LINE;
        }
        if (text.contains("\r")) {
            return "\r";
        }
        return STANDARD_NEW_LINE;
    }

    public String htmlCompatible(Object fieldValue) {
        return this.plainHtmlCompatible(fieldValue);
    }

    public String messageBody(String message) {
        return this.renderText(message.trim());
    }

    public String restQuery(String message) {
        return this.renderText(message.trim());
    }

    public String htmlCompatibleStoryTitle(Object fieldValue) {
        String firstLine = fieldValue.toString().split("\\n")[0];
        return MarkdownRendering.configuredIn((EnvironmentVariables)this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.story) ? this.htmlCompatible(this.renderMarkdown(firstLine)) : this.htmlCompatible(firstLine);
    }

    public String htmlCompatibleTestTitle(Object fieldValue) {
        String firstLine = fieldValue.toString().split("\\n")[0];
        return MarkdownRendering.configuredIn((EnvironmentVariables)this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.scenario) ? this.htmlCompatible(this.renderMarkdown(firstLine)) : this.htmlCompatible(firstLine);
    }

    public String htmlCompatibleStepDescription(Object fieldValue) {
        return MarkdownRendering.configuredIn((EnvironmentVariables)this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.step) ? this.htmlCompatible(this.renderMarkdown(fieldValue.toString())) : this.htmlCompatible(fieldValue);
    }

    public String plainHtmlCompatible(Object fieldValue) {
        return Formatter.addLineBreaks(ESCAPE_SPECIAL_CHARS.translate((CharSequence)(fieldValue != null ? Formatter.stringFormOf(fieldValue) : TEXT))).trim();
    }

    public String htmlAttributeCompatible(Object fieldValue) {
        if (fieldValue == null) {
            return TEXT;
        }
        return Formatter.concatLines(ESCAPE_SPECIAL_CHARS.translate((CharSequence)Formatter.stringFormOf(fieldValue).replaceAll("<", "(").replaceAll(">", ")").replaceAll("\"", "'")));
    }

    public String htmlAttributeCompatible(Object fieldValue, int maxLength) {
        return StringUtils.abbreviate((String)this.htmlAttributeCompatible(fieldValue), (int)maxLength);
    }

    public ResultIconFormatter resultIcon() {
        return new ResultIconFormatter();
    }

    public ResultRankingFormatter resultRank() {
        return new ResultRankingFormatter();
    }

    private static String concatLines(String message) {
        return Formatter.concatLines(message, " ");
    }

    private static String concatLines(String message, String newLine) {
        message = StringUtils.replace((String)message, (String)"\u2424", (String)newLine);
        List lines = Splitter.onPattern((String)NEW_LINE_ON_ANY_OS).splitToList((CharSequence)message);
        return StringUtils.join((Iterable)lines, (String)newLine);
    }

    private static String stringFormOf(Object fieldValue) {
        if (Iterable.class.isAssignableFrom(fieldValue.getClass())) {
            return "[" + StringUtils.join((Iterable)((Iterable)fieldValue), (String)", ") + "]";
        }
        return fieldValue.toString();
    }

    public String truncatedHtmlCompatible(String text, int length) {
        return this.htmlCompatible(text);
    }

    public String formatWithFields(String textToFormat) {
        String textWithEscapedFields = textToFormat.replaceAll("<", "&lt;").replaceAll(">", "&gt;");
        String renderedText = Formatter.addLineBreaks(this.removeMacros(this.convertAnyTables(textWithEscapedFields)));
        if (MarkdownRendering.configuredIn((EnvironmentVariables)this.environmentVariables).renderMarkdownFor(MarkdownRendering.RenderedElements.step)) {
            renderedText = this.renderMarkdown(renderedText);
        }
        return renderedText;
    }

    private String removeMacros(String textToFormat) {
        return textToFormat.replaceAll("\\{trim=false\\}\\s*\\r?\\n", TEXT);
    }
}

