/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Preconditions;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.serenitybdd.core.reports.styling.TagStylist;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.images.ResizableImage;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.Story;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.formatters.ReportFormatter;
import net.thucydides.core.reports.AcceptanceTestReporter;
import net.thucydides.core.reports.OutcomeFormat;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.HtmlReporter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.model.Requirement;
import net.thucydides.core.tags.BreadcrumbTagFilter;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlAcceptanceTestReporter
extends HtmlReporter
implements AcceptanceTestReporter {
    private static final String DEFAULT_ACCEPTANCE_TEST_REPORT = "freemarker/default.ftl";
    private static final String DEFAULT_ACCEPTANCE_TEST_SCREENSHOT = "freemarker/screenshots.ftl";
    private static final int MAXIMUM_SCREENSHOT_WIDTH = 1000;
    private static final Logger LOGGER = LoggerFactory.getLogger(HtmlAcceptanceTestReporter.class);
    private String qualifier;
    private final IssueTracking issueTracking;
    private RequirementsService requirementsService;

    public void setQualifier(String qualifier) {
        this.qualifier = qualifier;
    }

    public HtmlAcceptanceTestReporter() {
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    public HtmlAcceptanceTestReporter(RequirementsService requirementsService) {
        this.requirementsService = requirementsService;
        this.issueTracking = (IssueTracking)Injectors.getInjector().getInstance(IssueTracking.class);
    }

    public HtmlAcceptanceTestReporter(EnvironmentVariables environmentVariables, IssueTracking issueTracking) {
        super(environmentVariables);
        this.issueTracking = issueTracking;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    HtmlAcceptanceTestReporter(EnvironmentVariables environmentVariables, RequirementsService requirementsService, IssueTracking issueTracking) {
        super(environmentVariables);
        this.issueTracking = issueTracking;
        this.requirementsService = requirementsService;
    }

    private ReportNameProvider getReportNameProvider() {
        return new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService);
    }

    public String getName() {
        return "html";
    }

    public File generateReportFor(TestOutcome testOutcome) throws IOException {
        LOGGER.debug("GENERATE TEST OUTCOME REPORT FOR " + testOutcome.getName() + " in " + testOutcome.getReportName());
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        TestOutcome storedTestOutcome = testOutcome.withQualifier(this.qualifier);
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(storedTestOutcome, context);
        if (this.containsScreenshots(storedTestOutcome)) {
            this.generateScreenshotReportsFor(storedTestOutcome);
        }
        this.addFormattersToContext(context);
        this.addTimestamp(testOutcome, context);
        String reportFilename = this.reportFor(storedTestOutcome);
        LOGGER.debug("GENERATING HTML REPORT FOR {} in {} in directory {}  ", new Object[]{storedTestOutcome.getCompleteName() + (StringUtils.isNotEmpty((CharSequence)this.qualifier) ? "/" + this.qualifier : ""), reportFilename, this.getOutputDirectory()});
        this.copyResourcesToOutputDirectory();
        return this.generateReportPage(context, DEFAULT_ACCEPTANCE_TEST_REPORT, reportFilename);
    }

    private File generateReportPage(Map<String, Object> context, String template, String outputFile) throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        LOGGER.debug("Generating report in {}", (Object)outputFile);
        Path outputPath = this.getOutputDirectory().toPath().resolve(outputFile);
        try (BufferedWriter writer = Files.newBufferedWriter(outputPath, StandardCharsets.UTF_8, new OpenOption[0]);){
            this.mergeTemplate(template).withContext(context).to(writer);
            writer.flush();
        }
        LOGGER.debug("Generated report {} in {} ms", (Object)outputFile, (Object)stopwatch.stop());
        return outputPath.toFile();
    }

    private boolean containsScreenshots(TestOutcome testOutcome) {
        return testOutcome.getFlattenedTestSteps().stream().anyMatch(step -> step.getScreenshots() != null && !step.getScreenshots().isEmpty());
    }

    private void addTestOutcomeToContext(TestOutcome testOutcome, Map<String, Object> context) {
        context.put("testOutcome", testOutcome);
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("inflection", Inflector.getInstance());
        context.put("styling", TagStylist.from((EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class)));
        context.put("requirementTypes", this.requirementsService.getRequirementTypes());
        this.addParentRequirmentFieldToContext(testOutcome, context);
        this.addTimestamp(testOutcome, context);
    }

    private void addParentRequirmentFieldToContext(TestOutcome testOutcome, Map<String, Object> context) {
        Optional parentRequirement = this.requirementsService.getParentRequirementFor(testOutcome);
        Optional<Story> featureOrStory = Optional.ofNullable(testOutcome.getUserStory());
        String parentTitle = null;
        if (parentRequirement.isPresent()) {
            parentTitle = ((Requirement)parentRequirement.get()).getName();
            context.put("parentRequirement", parentRequirement);
            context.put("featureOrStory", Optional.empty());
            context.put("parentTitle", parentTitle);
            context.put("parentLink", this.getReportNameProvider().forRequirement((Requirement)parentRequirement.get()));
        } else if (featureOrStory.isPresent()) {
            parentTitle = featureOrStory.get().getName();
            context.put("parentRequirement", Optional.empty());
            context.put("featureOrStory", featureOrStory);
            context.put("parentTitle", parentTitle);
            context.put("parentLink", this.getReportNameProvider().forTag(featureOrStory.get().asTag()));
        }
        this.addBreadcrumbs(testOutcome, context);
        this.addTags(testOutcome, context, parentTitle);
    }

    private void addTags(TestOutcome testOutcome, Map<String, Object> context, String parentTitle) {
        TagFilter tagFilter = new TagFilter(this.getEnvironmentVariables());
        Set filteredTags = parentTitle != null ? tagFilter.removeTagsWithName(testOutcome.getTags(), parentTitle) : testOutcome.getTags();
        filteredTags = tagFilter.removeRequirementsTagsFrom(filteredTags);
        context.put("filteredTags", filteredTags);
    }

    private void addBreadcrumbs(TestOutcome testOutcome, Map<String, Object> context) {
        this.requirementsService.getAncestorRequirementsFor(testOutcome);
        List breadcrumbs = new BreadcrumbTagFilter(this.requirementsService).getRequirementBreadcrumbsFrom(testOutcome);
        context.put("breadcrumbs", breadcrumbs);
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter();
        ReportFormatter reportFormatter = new ReportFormatter();
        context.put("reportOptions", new ReportOptions(this.getEnvironmentVariables(), this.requirementsService));
        context.put("formatter", formatter);
        context.put("reportFormatter", reportFormatter);
        context.put("reportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService));
        VersionProvider versionProvider = new VersionProvider(this.getEnvironmentVariables());
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
    }

    private void generateScreenshotReportsFor(TestOutcome testOutcome) throws IOException {
        Preconditions.checkNotNull((Object)this.getOutputDirectory());
        List screenshots = testOutcome.getScreenshots();
        String screenshotReport = testOutcome.getReportName() + "_screenshots.html";
        HashMap<String, Object> context = new HashMap<String, Object>();
        this.addTestOutcomeToContext(testOutcome, context);
        this.addFormattersToContext(context);
        context.put("screenshots", screenshots);
        context.put("narrativeView", testOutcome.getReportName());
        this.generateReportPage(context, DEFAULT_ACCEPTANCE_TEST_SCREENSHOT, screenshotReport);
    }

    private boolean isValidScreenshotFile(File screenshotFile) {
        return screenshotFile.isFile() && screenshotFile.length() > 0L;
    }

    private int maxHeightOf(int maxHeight, File screenshotFile) throws IOException {
        int height = ResizableImage.loadFrom((File)screenshotFile).getHeight();
        int width = ResizableImage.loadFrom((File)screenshotFile).getWidth();
        if (width > 1000) {
            height = (int)((double)height * 1.0 * (1000.0 / (double)width));
        }
        if (height > maxHeight) {
            maxHeight = height;
        }
        return maxHeight;
    }

    private String reportFor(TestOutcome testOutcome) {
        return testOutcome.withQualifier(this.qualifier).getReportName(ReportType.HTML);
    }

    public Optional<OutcomeFormat> getFormat() {
        return Optional.of(OutcomeFormat.HTML);
    }
}

