/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import com.google.common.base.Splitter;
import java.time.Duration;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.serenitybdd.core.buildinfo.BuildInfoProvider;
import net.serenitybdd.core.buildinfo.BuildProperties;
import net.serenitybdd.core.reports.styling.TagStylist;
import net.serenitybdd.reports.model.BackgroundColor;
import net.serenitybdd.reports.model.DurationsKt;
import net.serenitybdd.reports.model.FrequentFailures;
import net.serenitybdd.reports.model.TagCoverage;
import net.serenitybdd.reports.model.TagResults;
import net.serenitybdd.reports.model.UnstableFeatures;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.NumericalFormatter;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.model.TestTag;
import net.thucydides.core.model.formatters.ReportFormatter;
import net.thucydides.core.reports.ReportOptions;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.EvidenceData;
import net.thucydides.core.reports.html.Formatter;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ResultCounts;
import net.thucydides.core.reports.html.TagFilter;
import net.thucydides.core.requirements.ParentRequirementProvider;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.requirements.reports.ScenarioOutcome;
import net.thucydides.core.requirements.reports.ScenarioOutcomes;
import net.thucydides.core.util.EnvironmentVariables;
import net.thucydides.core.util.Inflector;
import net.thucydides.core.util.VersionProvider;
import org.joda.time.DateTime;

public class FreemarkerContext {
    private final EnvironmentVariables environmentVariables;
    private final RequirementsService requirements;
    private final IssueTracking issueTracking;
    private final String relativeLink;
    private final BuildProperties buildProperties;
    private final TestTag parentTag;
    private final RequirementsService requirementsService;

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink, TestTag parentTag) {
        this.environmentVariables = environmentVariables;
        this.requirements = requirements;
        this.issueTracking = issueTracking;
        this.relativeLink = relativeLink;
        this.buildProperties = new BuildInfoProvider(environmentVariables).getBuildProperties();
        this.parentTag = parentTag;
        this.requirementsService = (RequirementsService)Injectors.getInjector().getInstance(RequirementsService.class);
    }

    public FreemarkerContext(EnvironmentVariables environmentVariables, RequirementsService requirements, IssueTracking issueTracking, String relativeLink) {
        this(environmentVariables, requirements, issueTracking, relativeLink, TestTag.EMPTY_TAG);
    }

    public Map<String, Object> getBuildContext(TestOutcomes testOutcomes, ReportNameProvider reportName, boolean useFiltering) {
        HashMap<String, Object> context = new HashMap<String, Object>();
        TagFilter tagFilter = new TagFilter(this.environmentVariables);
        context.put("testOutcomes", testOutcomes);
        context.put("allTestOutcomes", testOutcomes.getRootOutcomes());
        if (useFiltering) {
            context.put("tagTypes", tagFilter.filteredTagTypes(testOutcomes.getTagTypes()));
        } else {
            context.put("tagTypes", testOutcomes.getTagTypes());
        }
        context.put("currentTag", TestTag.EMPTY_TAG);
        context.put("parentTag", this.parentTag);
        context.put("reportName", reportName);
        context.put("absoluteReportName", new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirements));
        context.put("reportOptions", new ReportOptions(this.environmentVariables));
        context.put("timestamp", this.timestampFrom(new DateTime()));
        context.put("requirementTypes", this.requirements.getRequirementTypes());
        context.put("leafRequirementType", this.last(this.requirements.getRequirementTypes()));
        this.addFormattersToContext(context);
        context.put("totalTestDuration", DurationsKt.formattedDuration((Duration)Duration.ofMillis(testOutcomes.getDuration())));
        context.put("totalClockDuration", DurationsKt.formattedDuration((Duration)DurationsKt.clockDurationOf((List)testOutcomes.getOutcomes())));
        context.put("averageTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.averageDurationOf((List)testOutcomes.getOutcomes())));
        context.put("maxTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.maxDurationOf((List)testOutcomes.getOutcomes())));
        context.put("minTestDuration", DurationsKt.formattedDuration((Duration)DurationsKt.minDurationOf((List)testOutcomes.getOutcomes())));
        VersionProvider versionProvider = new VersionProvider(this.environmentVariables);
        context.put("serenityVersionNumber", versionProvider.getVersion());
        context.put("buildNumber", versionProvider.getBuildNumberText());
        context.put("build", this.buildProperties);
        context.put("resultCounts", ResultCounts.forOutcomesIn((TestOutcomes)testOutcomes));
        List scenarios = ScenarioOutcomes.from((TestOutcomes)testOutcomes);
        context.put("scenarios", scenarios);
        context.put("testCases", this.executedScenariosIn(scenarios));
        context.put("automatedTestCases", this.automated(this.executedScenariosIn(scenarios)));
        context.put("manualTestCases", this.manual(this.executedScenariosIn(scenarios)));
        context.put("evidence", EvidenceData.from(testOutcomes));
        context.put("frequentFailures", FrequentFailures.from((TestOutcomes)testOutcomes).withMaxOf(5));
        context.put("unstableFeatures", UnstableFeatures.from((TestOutcomes)testOutcomes).withRequirementsFrom((ParentRequirementProvider)this.requirementsService).withMaxOf(5));
        List tagTypes = Splitter.on((String)",").trimResults().splitToList((CharSequence)ThucydidesSystemProperty.REPORT_TAGTYPES.from(this.environmentVariables, "feature"));
        context.put("inflection", Inflector.getInstance());
        Collection coveredTags = this.requirements.getTagsOfType(tagTypes).stream().filter(tag -> testOutcomes.containsTagMatching(tag)).collect(Collectors.toSet());
        context.put("coverage", TagCoverage.from((TestOutcomes)testOutcomes).showingTags(coveredTags).forTagTypes(tagTypes));
        context.put("backgroundColor", new BackgroundColor());
        testOutcomes.getOutcomes().forEach(testOutcome -> this.addTags((TestOutcome)testOutcome, (Map<String, Object>)context, null));
        context.put("tagResults", TagResults.from((TestOutcomes)testOutcomes).groupedByType());
        return context;
    }

    private void addTags(TestOutcome testOutcome, Map<String, Object> context, String parentTitle) {
        TagFilter tagFilter = new TagFilter(this.environmentVariables);
        Set filteredTags = parentTitle != null ? tagFilter.removeTagsWithName(testOutcome.getTags(), parentTitle) : testOutcome.getTags();
        filteredTags = tagFilter.removeRequirementsTagsFrom(filteredTags);
        context.put("filteredTags", filteredTags);
    }

    private String last(List<String> requirementTypes) {
        return requirementTypes.size() > 0 ? requirementTypes.get(requirementTypes.size() - 1) : "Feature";
    }

    private List<ScenarioOutcome> automated(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual() == false).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> manual(List<ScenarioOutcome> executedScenariosIn) {
        return executedScenariosIn.stream().filter(scenarioOutcome -> scenarioOutcome.isManual()).collect(Collectors.toList());
    }

    private List<ScenarioOutcome> executedScenariosIn(List<ScenarioOutcome> scenarioOutcomes) {
        return scenarioOutcomes.stream().filter(scenarioOutcome -> !scenarioOutcome.getType().equalsIgnoreCase("background")).collect(Collectors.toList());
    }

    private void addFormattersToContext(Map<String, Object> context) {
        Formatter formatter = new Formatter();
        ReportFormatter reportFormatter = new ReportFormatter();
        context.put("formatter", formatter);
        context.put("reportFormatter", reportFormatter);
        context.put("formatted", new NumericalFormatter());
        context.put("inflection", Inflector.getInstance());
        context.put("styling", TagStylist.from(this.environmentVariables));
        context.put("relativeLink", this.relativeLink);
        context.put("reportOptions", new ReportOptions(this.environmentVariables));
    }

    protected String timestampFrom(DateTime startTime) {
        return startTime == null ? "" : startTime.toString("dd-MM-YYYY HH:mm");
    }

    public FreemarkerContext withParentTag(TestTag knownTag) {
        return new FreemarkerContext(this.environmentVariables, this.requirements, this.issueTracking, this.relativeLink, knownTag);
    }
}

