/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import net.thucydides.core.reports.ExtendedReport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtendedReports {
    private static List<ExtendedReport> extendedReports;
    private static final Logger LOGGER;

    public static List<ExtendedReport> named(List<String> reportNames) {
        ExtendedReports.ensureAllReportsExistForReportNames(reportNames);
        return ExtendedReports.getReports().stream().filter(report -> reportNames.contains(report.getName())).collect(Collectors.toList());
    }

    private static void ensureAllReportsExistForReportNames(List<String> reportNames) {
        List knownReports = ExtendedReports.getReports().stream().map(report -> report.getName()).collect(Collectors.toList());
        reportNames.stream().forEach(reportName -> {
            if (!knownReports.contains(reportName)) {
                LOGGER.warn("No report found on classpath with name " + reportName);
            }
        });
    }

    private static List<ExtendedReport> getReports() {
        if (extendedReports == null) {
            extendedReports = new ArrayList<ExtendedReport>();
            ServiceLoader.load(ExtendedReport.class).forEach(report -> extendedReports.add((ExtendedReport)report));
        }
        return extendedReports;
    }

    static {
        LOGGER = LoggerFactory.getLogger(ExtendedReports.class);
    }
}

