/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.model.ReportType;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.BaseReportingTask;
import net.thucydides.core.reports.html.FreemarkerContext;
import net.thucydides.core.reports.html.ReportNameProvider;
import net.thucydides.core.reports.html.ReportProperties;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;

public class ErrorTypeReportingTask
extends BaseReportingTask
implements ReportingTask {
    private static final String HOME_PAGE_TEMPLATE_PATH = "freemarker/home.ftl";
    private final RequirementsService requirementsService;
    private final TestOutcomes testOutcomes;
    private final String filename;

    public ErrorTypeReportingTask(FreemarkerContext context, EnvironmentVariables environmentVariables, RequirementsService requirementsService, File outputDirectory, ReportNameProvider reportNameProvider, TestOutcomes testOutcomes, String errorType) {
        super(context, environmentVariables, outputDirectory);
        this.requirementsService = requirementsService;
        this.testOutcomes = testOutcomes;
        this.filename = reportNameProvider.forErrorType(errorType);
    }

    @Override
    public void generateReports() throws IOException {
        Stopwatch stopwatch = Stopwatch.started();
        ReportNameProvider defaultNameProvider = new ReportNameProvider(ReportNameProvider.NO_CONTEXT, ReportType.HTML, this.requirementsService);
        Map<String, Object> context = this.freemarker.getBuildContext(this.testOutcomes, defaultNameProvider, true);
        context.put("report", ReportProperties.forAggregateResultsReport());
        context.put("csvReport", "results.csv");
        this.generateReportPage(context, HOME_PAGE_TEMPLATE_PATH, this.filename);
        LOGGER.debug("Error type reports generated in {} ms ", (Object)stopwatch.stop());
    }
}

