/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import net.thucydides.core.issues.IssueTracking;
import net.thucydides.core.model.TestOutcome;
import net.thucydides.core.reports.TestOutcomes;
import net.thucydides.core.reports.html.HtmlAcceptanceTestReporter;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.requirements.RequirementsService;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HtmlTestOutcomeReportingTask
implements ReportingTask {
    private final TestOutcome testOutcome;
    private final File outputDirectory;
    private final RequirementsService requirementsService;
    private final EnvironmentVariables environmentVariables;
    private final IssueTracking issueTracking;
    protected static final Logger LOGGER = LoggerFactory.getLogger(HtmlTestOutcomeReportingTask.class);

    public HtmlTestOutcomeReportingTask(TestOutcome testOutcome, File outputDirectory, RequirementsService requirementsService, EnvironmentVariables environmentVariables, IssueTracking issueTracking) {
        this.testOutcome = testOutcome;
        this.outputDirectory = outputDirectory;
        this.requirementsService = requirementsService;
        this.environmentVariables = environmentVariables;
        this.issueTracking = issueTracking;
    }

    @Override
    public void generateReports() throws IOException {
        HtmlAcceptanceTestReporter reporter = new HtmlAcceptanceTestReporter(this.environmentVariables, this.requirementsService, this.issueTracking);
        reporter.setOutputDirectory(this.outputDirectory);
        reporter.generateReportFor(this.testOutcome);
    }

    public static TestOutcomeReportBuilder testOutcomeReportsFor(TestOutcomes testOutcomes) {
        return new TestOutcomeReportBuilder(testOutcomes);
    }

    public static class TestOutcomeReportBuilder {
        private final TestOutcomes testOutcomes;

        public TestOutcomeReportBuilder(TestOutcomes testOutcomes) {
            this.testOutcomes = testOutcomes;
        }

        public Set<ReportingTask> using(EnvironmentVariables environmentVariables, RequirementsService requirementsService, File outputDirectory, IssueTracking issueTracking) {
            HashSet<ReportingTask> reportingTasks = new HashSet<ReportingTask>();
            LOGGER.trace("GENERATE TEST OUTCOME REPORTS FOR " + this.testOutcomes.getOutcomes());
            for (TestOutcome outcome : this.testOutcomes.getOutcomes()) {
                reportingTasks.add(new HtmlTestOutcomeReportingTask(outcome, outputDirectory, requirementsService, environmentVariables, issueTracking));
            }
            return reportingTasks;
        }
    }
}

