/*
 * Decompiled with CFR 0.152.
 */
package net.thucydides.core.reports.html;

import java.util.concurrent.Callable;
import net.serenitybdd.core.time.Stopwatch;
import net.thucydides.core.ThucydidesSystemProperty;
import net.thucydides.core.guice.Injectors;
import net.thucydides.core.reports.html.ReportingTask;
import net.thucydides.core.util.EnvironmentVariables;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ReportExecutor
implements Callable<Void> {
    private final ReportingTask reportingTask;
    protected static final Logger LOGGER = LoggerFactory.getLogger(ReportExecutor.class);
    private final EnvironmentVariables environmentVariables = (EnvironmentVariables)Injectors.getInjector().getInstance(EnvironmentVariables.class);

    public ReportExecutor(ReportingTask reportingTask) {
        this.reportingTask = reportingTask;
    }

    public ReportingTask getReportingTask() {
        return this.reportingTask;
    }

    @Override
    public Void call() throws Exception {
        Stopwatch reportingStopwatch = Stopwatch.started();
        if (this.verboseReporting().booleanValue()) {
            LOGGER.debug("Generating report {}...", (Object)this.reportingTask);
        }
        this.reportingTask.generateReports();
        if (this.verboseReporting().booleanValue()) {
            LOGGER.debug("Report {} generated in {} ms", (Object)this.reportingTask, (Object)reportingStopwatch.stop());
        }
        return null;
    }

    private Boolean verboseReporting() {
        return ThucydidesSystemProperty.VERBOSE_REPORTING.booleanFrom(this.environmentVariables, Boolean.valueOf(false));
    }
}

